/**
 * JASMINe
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: ConstantCollector.java 8625 2011-07-22 14:11:22Z durieuxp $
 * --------------------------------------------------------------------------
 */

package org.ow2.jasmine.probe.collectors;

import org.ow2.jasmine.probe.JasmineIndicValue;
import org.ow2.jasmine.probe.JasmineIndicator;
import org.ow2.jasmine.probe.JasmineSingleResult;
import org.ow2.jasmine.probe.collector.JasmineCollectorException;

/**
 * Dummy Collector for constant values
 * This Collector return always the same value
 * @author durieuxp
 */
public class ConstantCollector extends JCollector {

    private String value;
    private Number number;

    /**
     * Constructor
     * @param name is the value as a String
     * @param indic
     * @param period  not used
     */
    public ConstantCollector(String name, JasmineIndicator indic, int period) {
        super(name, indic, period);
        this.value = name;
        // TODO float ?
        number = Integer.parseInt(value);
    }

    /**
     * return the last result for this indicator
     * @return JasmineIndicValue or null if no value available
     * @throws JasmineCollectorException
     */
    @Override
    public JasmineIndicValue getLastResult() throws JasmineCollectorException {
        JasmineIndicValue jiv = new JasmineIndicValue();
        JasmineSingleResult val = new JasmineSingleResult();
        val.setName(value);
        val.setTimestamp(System.currentTimeMillis());
        val.setValue(number);
        jiv.setName(indicator.getName());
        jiv.addValue(val);
        return jiv;
    }

    /**
     * Stop polling
     */
    @Override
    public void stopPolling() {
        // nothing to do.
    }
}
