/**
 * JASMINe
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: ProbeCommandParameters.java 8615 2011-07-21 13:56:21Z danesa $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.probe.shell;

import java.util.ArrayList;
import java.util.List;

import com.beust.jcommander.Parameter;

/**
 * Parameters for probe command.
 * @author danesa
 */
public class ProbeCommandParameters extends JasmineProbeCommandParams {


    @Parameter(description = "Probe name")
    public List<String> name = new ArrayList<String>();

    @Parameter(names = { "-i", "--indicators" }, description = "Indicator names", required = true)
    private String indicators;

    @Parameter(names = { "-o", "--outputs" }, description = "Output names", required = true)
    private String outputs;

    // Default value for period is 10s
    @Parameter(names = { "-p", "--period" }, description = "Execution period", required = true)
    private int period = 10;


    public String getName() {
        return name.get(0);
    }

    public String getIndicators() {
        return indicators;
    }

    public String getOutputs() {
        return outputs;
    }

    public int getPeriod() {
        return period;
    }

    public void reset() {
        name = null;
        indicators = null;
        outputs = null;
        period = 10;
    }
}
