/**
 * JASMINe
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: ProbeListCommand.java 8491 2011-07-05 13:09:56Z durieuxp $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.probe.shell;

import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.shell.Command;
import org.ow2.jasmine.probe.JasmineProbe;
import org.ow2.jasmine.probe.JasmineProbeManager;

import java.io.PrintStream;
import java.util.Collection;

/**
 * Implements probe-list command that list the name of all the created probes.
 * @author danesa
 */
@Component(name="ProbeListCommand")
@Provides
public class ProbeListCommand extends JasmineProbeCommand implements Command {

    /**
     * command name
     */
    private String name = "probe-list";

    /**
     * command usage
     */
    private String usage = name;

    /**
     * command description
     */
    private String description = "list JasmineProbe probes";


    // ----------------------------------------------------------------------------
    // ipojo management
    // ----------------------------------------------------------------------------

    @Requires
    JasmineProbeManager probeManager = null;

    // ----------------------------------------------------------------------------
    // constructors
    // ----------------------------------------------------------------------------

    /**
     * Default Constructor
     */
    public ProbeListCommand() {
    }

    // ----------------------------------------------------------------------------
    // org.apache.felix.shell.Command implementation
    // ----------------------------------------------------------------------------

    /**
     * Returns the name of the command that is implemented by the interface.
     * The command name should not contain whitespace and should also be unique.
     * @return the name of the command.
     */
    public String getName() {
        return name;
    }

    /**
     * Returns the usage string for the command.
     * The usage string is a short string that illustrates how to use the command on the command line.
     * This information is used when generating command help information.
     * @return the usage string for the command.
     */
    public String getUsage() {
        return usage;
    }

    /**
     * Returns a short description of the command; this description should be as short as possible.
     * This information is used when generating the command help information.
     * @return a short description of the command.
     */
    public String getShortDescription() {
        return description;
    }

    /**
     * Executes the command using the supplied command line, output print stream, and error print stream.
     * @param line the complete command line, including the command name.
     * @param out  the print stream to use for standard output.
     * @param err  the print stream to use for standard error.
     */
    public void execute(String line, PrintStream out, PrintStream err) {
        Collection<JasmineProbe> probes = probeManager.getProbes();
        for (JasmineProbe probe : probes) {
            String probeName = probe.getId();
            out.println(probeName);
        }
    }
}
