/**
 * JASMINe
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: TargetShowCommand.java 8657 2011-07-26 08:58:59Z danesa $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.probe.shell;

import java.io.PrintStream;
import java.util.Collection;

import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.shell.Command;
import org.ow2.jasmine.probe.JasmineProbeManager;
import org.ow2.jasmine.probe.JasmineTarget;

/**
 * Implements target-show command that shows the properties of a target.
 * @author danesa
 */
@Component(name="TargetShowCommand")
@Provides
public class TargetShowCommand extends JasmineProbeCommand implements Command {

    /**
     * command name
     */
    private String name = "target-show";

    /**
     * command usage
     */
    private String usage = name + " <targettName>";

    /**
     * command description
     */
    private String description = "show a JasmineProbe target";


    // ----------------------------------------------------------------------------
    // ipojo management
    // ----------------------------------------------------------------------------

    @Requires
    JasmineProbeManager probeManager = null;

    // ----------------------------------------------------------------------------
    // constructors
    // ----------------------------------------------------------------------------

    /**
     * Default Constructor
     */
    public TargetShowCommand() {
        super();
        setParams(new TargetCommandParameters());
    }


    // ----------------------------------------------------------------------------
    // org.apache.felix.shell.Command implementation
    // ----------------------------------------------------------------------------

    /**
     * Returns the name of the command that is implemented by the interface.
     * The command name should not contain whitespace and should also be unique.
     * @return the name of the command.
     */
    public String getName() {
        return name;
    }

    /**
     * Returns the usage string for the command.
     * The usage string is a short string that illustrates how to use the command on the command line.
     * This information is used when generating command help information.
     * @return the usage string for the command.
     */
    public String getUsage() {
        return usage;
    }

    /**
     * Returns a short description of the command; this description should be as short as possible.
     * This information is used when generating the command help information.
     * @return a short description of the command.
     */
    public String getShortDescription() {
        return description;
    }

    /**
     * Executes the command using the supplied command line, output print stream, and error print stream.
     * @param line the complete command line, including the command name.
     * @param out  the print stream to use for standard output.
     * @param err  the print stream to use for standard error.
     */
    public void execute(String line, PrintStream out, PrintStream err) {
        boolean validOptions = parseOptions(line, out, err);
        if (!validOptions) {
            return;
        }
        TargetCommandParameters params = ((TargetCommandParameters) getParams());

        String targetName = params.getName();

        // reset params
        params.reset();

        Collection<JasmineTarget> targets = probeManager.getTargets();

        for (JasmineTarget target : targets) {
            if (targetName.equals(target.getName())) {
                // show output
                out.println(target.toString());
            }
        }

    }

}
