/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.shell;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.beanutils.PropertyUtils;
import org.ow2.jasmine.probe.JasmineProbeException;
import org.ow2.jasmine.probe.JasminePropertyInfo;
import org.ow2.jasmine.probe.shell.JasmineProbeCommandParams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JasmineProbeCommand {
    private JasmineProbeCommandParams params = new JasmineProbeCommandParams();

    public abstract String getName();

    public void setParams(JasmineProbeCommandParams params) {
        this.params = params;
    }

    public JasmineProbeCommandParams getParams() {
        return this.params;
    }

    protected boolean parseOptions(String line, PrintStream out, PrintStream err) {
        String options = line.substring(this.getName().length()).trim();
        if (options.length() == 0) {
            err.println(this.getName() + " command: options missing");
            return false;
        }
        StringTokenizer st = new StringTokenizer(options);
        String[] argv = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            argv[i++] = st.nextToken();
        }
        JCommander commander = null;
        try {
            commander = new JCommander((Object)this.params, argv);
        }
        catch (ParameterException pe) {
            err.println(pe.getMessage());
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    protected Map<String, String> parseProperties(Collection<JasminePropertyInfo> propsInfo, JasmineProbeCommandParams params) throws JasmineProbeException {
        HashMap<String, String> properties = new HashMap<String, String>();
        for (JasminePropertyInfo propInfo : propsInfo) {
            String key = propInfo.getName();
            String value = null;
            try {
                value = (String)PropertyUtils.getSimpleProperty((Object)params, (String)key);
            }
            catch (Exception e) {
                throw new JasmineProbeException(this.getName() + " command: cannot get options for " + key + " property (" + e.toString() + ")");
            }
            properties.put(key, value);
        }
        return properties;
    }
}

