/**
 * JASMINe
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: ProbeCommandsParams.java 8785 2011-09-01 13:16:54Z durieuxp $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.probe.shell;

import java.util.ArrayList;
import java.util.List;

import com.beust.jcommander.Parameter;

/**
 * Parameters for probe commands having only one parameter, the probe's name (probe-start, probe-stop etc..)
 * @author danesa
 */
public class ProbeCommandsParams extends JasmineProbeCommandParams {

    @Parameter(description = "Probe name", required = false)
    public List<String> names = new ArrayList<String>();

    public String getName() {
        if (names.size() > 0) {
            return names.get(0);
        } else {
            return null;
        }
    }

    public void reset() {
        names = new ArrayList<String>();
    }
}
