/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.collectors;

import java.util.Collection;
import org.ow2.jasmine.probe.JasmineIndicator;
import org.ow2.jasmine.probe.JasmineIndicatorValue;
import org.ow2.jasmine.probe.collector.JasmineCollector;
import org.ow2.jasmine.probe.collector.JasmineCollectorException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JCollector
implements JasmineCollector {
    protected Log logger = LogFactory.getLog(JCollector.class);
    protected JasmineIndicator indicator;
    protected int period;
    protected String name;

    public JCollector(String name, JasmineIndicator def, int period) {
        this.name = name;
        this.indicator = def;
        this.period = period;
    }

    public JasmineIndicator getIndicator() {
        return this.indicator;
    }

    public String getName() {
        return this.name;
    }

    public abstract JasmineIndicatorValue getLastResult() throws JasmineCollectorException;

    public abstract void stopPolling();

    public abstract void startPolling();

    protected long diffValues(Number v1, Number v2) throws JasmineCollectorException {
        return this.longValue(v1) - this.longValue(v2);
    }

    protected long divideValues(Number v1, Number v2) throws JasmineCollectorException {
        if (this.longValue(v2) == 0L) {
            return 1L;
        }
        return this.longValue(v1) / this.longValue(v2);
    }

    protected long addValues(Collection<Number> values) throws JasmineCollectorException {
        long ret = 0L;
        for (Number o : values) {
            ret += this.longValue(o);
        }
        return ret;
    }

    protected long multiplyValues(Collection<Number> values) throws JasmineCollectorException {
        long ret = 0L;
        for (Number o : values) {
            ret *= this.longValue(o);
        }
        return ret;
    }

    protected long longValue(Number nb) throws JasmineCollectorException {
        long val;
        if (nb instanceof Integer) {
            val = ((Integer)nb).longValue();
        } else if (nb instanceof Long) {
            val = (Long)nb;
        } else if (nb instanceof Short) {
            val = ((Short)nb).longValue();
        } else {
            throw new JasmineCollectorException("This type is not implemented");
        }
        return val;
    }
}

