/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.manager;

import java.util.List;
import org.ow2.jasmine.probe.JasmineIndicatorValue;
import org.ow2.jasmine.probe.JasmineProbe;
import org.ow2.jasmine.probe.JasmineProbeResult;
import org.ow2.jasmine.probe.collector.JasmineCollector;
import org.ow2.jasmine.probe.collector.JasmineCollectorException;
import org.ow2.jasmine.probe.outer.JasmineOuter;
import org.ow2.jasmine.probe.probescheduler.TaskReference;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JProbe
implements Runnable {
    protected static Log logger = LogFactory.getLog(JProbe.class);
    JasmineProbe probeDef;
    TaskReference task;
    List<JasmineCollector> collectors;
    List<JasmineOuter> outers;

    public JProbe(JasmineProbe def) {
        this.probeDef = def;
        def.setError("");
    }

    public JasmineProbe getProbeDef() {
        return this.probeDef;
    }

    public int getStatus() {
        return this.probeDef.getStatus();
    }

    public void setStatus(int state) {
        this.probeDef.setStatus(state);
    }

    public void setError(String mess) {
        this.probeDef.setError(mess);
    }

    public void setTask(TaskReference task) {
        this.task = task;
    }

    public List<JasmineOuter> getOuters() {
        return this.outers;
    }

    public void setOuters(List<JasmineOuter> outers) {
        this.outers = outers;
    }

    public List<JasmineCollector> getCollectors() {
        return this.collectors;
    }

    public void setCollectors(List<JasmineCollector> collectors) {
        this.collectors = collectors;
    }

    public void halt() {
        logger.debug((Object)"", new Object[0]);
        if (this.task != null) {
            this.task.cancel(true);
            this.task = null;
        }
        for (JasmineCollector collector : this.collectors) {
            collector.stopPolling();
        }
        this.probeDef.setStatus(0);
    }

    public void launch() {
        logger.debug((Object)"", new Object[0]);
        for (JasmineCollector collector : this.collectors) {
            collector.startPolling();
        }
        this.probeDef.setStatus(1);
    }

    @Override
    public void run() {
        logger.debug((Object)"", new Object[0]);
        JasmineProbeResult result = new JasmineProbeResult(this.probeDef.getId());
        for (JasmineCollector collector : this.collectors) {
            try {
                JasmineIndicatorValue val = collector.getLastResult();
                if (val != null) {
                    result.addValue(val);
                    continue;
                }
                logger.debug((Object)("No result found for " + collector.getName()), new Object[0]);
            }
            catch (JasmineCollectorException e) {
                logger.warn((Object)("Cannot get results on " + collector.getName() + " :" + (Object)((Object)e)), new Object[0]);
            }
            catch (NullPointerException e) {
                logger.error((Object)"NPE in run method", new Object[0]);
                e.printStackTrace();
            }
        }
        for (JasmineOuter outer : this.outers) {
            outer.publishData(result);
        }
    }
}

