/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.outers;

import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import org.ow2.jasmine.probe.JasmineOutput;
import org.ow2.jasmine.probe.JasmineProbeResult;
import org.ow2.jasmine.probe.JasmineSingleResult;
import org.ow2.jasmine.probe.outer.JasmineOuter;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JOuter
extends Thread
implements JasmineOuter {
    protected Log logger = LogFactory.getLog(JOuter.class);
    private LinkedList<JasmineProbeResult> dataqueue = new LinkedList();
    protected static final String SEPARATOR = ";";
    protected static final String NAME_SEPARATOR = ".";
    private boolean valid = true;
    private boolean waiting = false;
    private long outerTimeout = 10000L;
    protected SimpleDateFormat dateformat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");

    public abstract void processData(JasmineProbeResult var1);

    public JOuter(JasmineOutput output) {
        super("JasmineOuter-" + output.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.valid) {
            JasmineProbeResult data = null;
            JOuter jOuter = this;
            synchronized (jOuter) {
                if (this.dataqueue.isEmpty()) {
                    try {
                        this.waiting = true;
                        this.wait(this.outerTimeout);
                        this.waiting = false;
                    }
                    catch (InterruptedException e) {
                        this.logger.warn((Object)(this.getName() + ": outer interrupted"), new Object[]{e});
                    }
                    catch (Exception e) {
                        this.logger.warn((Object)(this.getName() + ": outer exception"), new Object[]{e});
                    }
                }
                try {
                    data = this.dataqueue.removeFirst();
                }
                catch (NoSuchElementException e) {
                    data = null;
                }
            }
            if (data == null) continue;
            this.processData(data);
        }
    }

    public synchronized void stopIt() {
        this.valid = false;
        this.notify();
    }

    public synchronized void publishData(JasmineProbeResult result) {
        this.logger.debug((Object)"", new Object[0]);
        this.dataqueue.addLast(result);
        if (this.waiting) {
            this.notify();
        }
    }

    protected boolean simpleDataName(String name, Collection<JasmineSingleResult> jsrs) {
        boolean result = true;
        if (jsrs.size() > 1) {
            String oneResultName = null;
            for (JasmineSingleResult jsr : jsrs) {
                String resultName = jsr.getName();
                if (oneResultName == null) {
                    oneResultName = resultName;
                }
                if (oneResultName.equals(resultName)) continue;
                result = false;
                return result;
            }
            result = oneResultName.equals(name);
        }
        return result;
    }

    protected String composeName(String indicatorName, String resultName) {
        return indicatorName + NAME_SEPARATOR + resultName;
    }
}

