/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.manager.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Bind;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Invalidate;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.ipojo.annotations.Unbind;
import org.apache.felix.ipojo.annotations.Validate;
import org.osgi.framework.ServiceReference;
import org.ow2.jasmine.probe.JProbeManagerMXBean;
import org.ow2.jasmine.probe.JasmineIndicator;
import org.ow2.jasmine.probe.JasmineOutput;
import org.ow2.jasmine.probe.JasmineProbe;
import org.ow2.jasmine.probe.JasmineProbeException;
import org.ow2.jasmine.probe.JasmineProbeListener;
import org.ow2.jasmine.probe.JasmineProbeManager;
import org.ow2.jasmine.probe.JasminePropertyInfo;
import org.ow2.jasmine.probe.JasmineTarget;
import org.ow2.jasmine.probe.PropertyMissingException;
import org.ow2.jasmine.probe.TypeNotSupportedException;
import org.ow2.jasmine.probe.collector.JasmineAggregateService;
import org.ow2.jasmine.probe.collector.JasmineCollector;
import org.ow2.jasmine.probe.collector.JasmineCollectorException;
import org.ow2.jasmine.probe.collector.JasmineCollectorService;
import org.ow2.jasmine.probe.manager.JProbe;
import org.ow2.jasmine.probe.outer.JasmineOuterService;
import org.ow2.jasmine.probe.probemanager.ProbeManager;
import org.ow2.jasmine.probe.probemanager.generated.Indicator;
import org.ow2.jasmine.probe.probemanager.generated.IndicatorType;
import org.ow2.jasmine.probe.probemanager.generated.ObjectFactory;
import org.ow2.jasmine.probe.probemanager.generated.Output;
import org.ow2.jasmine.probe.probemanager.generated.OutputType;
import org.ow2.jasmine.probe.probemanager.generated.Paramvalue;
import org.ow2.jasmine.probe.probemanager.generated.Probe;
import org.ow2.jasmine.probe.probemanager.generated.ProbeConfig;
import org.ow2.jasmine.probe.probemanager.generated.StatusType;
import org.ow2.jasmine.probe.probemanager.generated.Target;
import org.ow2.jasmine.probe.probescheduler.SchedulerService;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(name="JasmineProbeManagerService")
@Provides
public class JProbeManager
implements JasmineProbeManager,
ProbeManager,
JProbeManagerMXBean,
Pojo {
    private InstanceManager __IM;
    protected static Log logger = LogFactory.getLog(JProbe.class);
    private boolean __FprobeConfig;
    private ProbeConfig probeConfig;
    private boolean __Fprobes;
    private Map<String, JasmineProbe> probes;
    private boolean __Foutputs;
    private Map<String, JasmineOutput> outputs;
    private boolean __Findicators;
    private Map<String, JasmineIndicator> indicators;
    private boolean __Ftargets;
    private Map<String, JasmineTarget> targets;
    private boolean __Frunnings;
    private Map<String, JProbe> runnings;
    private boolean __Fouterservices;
    private Map<String, JasmineOuterService> outerservices;
    private boolean __Fcollectorservices;
    private Map<String, JasmineCollectorService> collectorservices;
    private boolean __Faggregateservices;
    private Map<String, JasmineAggregateService> aggregateservices;
    private boolean __FprobeListeners;
    private List<JasmineProbeListener> probeListeners;
    private boolean __FprobeCount;
    private int probeCount;
    private boolean __FmbeanObjectName;
    private ObjectName mbeanObjectName;
    private boolean __FjasmineProbeScheduler;
    @Requires
    protected SchedulerService jasmineProbeScheduler;
    private boolean __FjmxService;
    @Requires
    protected JmxService jmxService;
    private boolean __Mstart;
    private boolean __Mstop;
    private boolean __MbindOuterService$org_ow2_jasmine_probe_outer_JasmineOuterService$org_osgi_framework_ServiceReference;
    private boolean __MunbindOuterService$org_ow2_jasmine_probe_outer_JasmineOuterService$org_osgi_framework_ServiceReference;
    private boolean __MbindCollectorService$org_ow2_jasmine_probe_collector_JasmineCollectorService$org_osgi_framework_ServiceReference;
    private boolean __MunbindCollectorService$org_ow2_jasmine_probe_collector_JasmineCollectorService$org_osgi_framework_ServiceReference;
    private boolean __MbindAggregateService$org_ow2_jasmine_probe_collector_JasmineAggregateService$org_osgi_framework_ServiceReference;
    private boolean __MunbindAggregateService$org_ow2_jasmine_probe_collector_JasmineAggregateService$org_osgi_framework_ServiceReference;
    private boolean __MgetScheduler;
    private boolean __MgetOuterService$java_lang_String;
    private boolean __MgetCollectorService$java_lang_String;
    private boolean __McreateProbe$org_ow2_jasmine_probe_JasmineProbe;
    private boolean __MremoveProbe$java_lang_String;
    private boolean __MremoveAllProbes;
    private boolean __MgetProbes;
    private boolean __MlistProbes;
    private boolean __MgetProbe$java_lang_String;
    private boolean __MstartProbe$java_lang_String;
    private boolean __MstopProbe$java_lang_String;
    private boolean __MstartAllProbes;
    private boolean __MstopAllProbes;
    private boolean __MchangeProbe$org_ow2_jasmine_probe_JasmineProbe;
    private boolean __McreateOutput$org_ow2_jasmine_probe_JasmineOutput;
    private boolean __MchangeOutput$org_ow2_jasmine_probe_JasmineOutput;
    private boolean __MremoveOutput$java_lang_String;
    private boolean __MlistOutputs;
    private boolean __MgetOutputs;
    private boolean __MgetOutput$java_lang_String;
    private boolean __MgetOutputPropertyInfos$java_lang_String;
    private boolean __MgetOutputTypes;
    private boolean __MgetOutputCurrentUse$java_lang_String;
    private boolean __McreateIndicator$org_ow2_jasmine_probe_JasmineIndicator;
    private boolean __MchangeIndicator$org_ow2_jasmine_probe_JasmineIndicator;
    private boolean __MremoveIndicator$java_lang_String;
    private boolean __MgetIndicator$java_lang_String;
    private boolean __MgetIndicators;
    private boolean __MlistIndicators;
    private boolean __MgetIndicatorPropertyInfos$java_lang_String;
    private boolean __MgetIndicatorTypes;
    private boolean __MgetIndicatorCurrentUse$java_lang_String;
    private boolean __McreateTarget$org_ow2_jasmine_probe_JasmineTarget;
    private boolean __MchangeTarget$org_ow2_jasmine_probe_JasmineTarget;
    private boolean __MremoveTarget$java_lang_String;
    private boolean __MlistTargets;
    private boolean __MgetTargets;
    private boolean __MgetTarget$java_lang_String;
    private boolean __MaddProbeListener$org_ow2_jasmine_probe_JasmineProbeListener;
    private boolean __MsaveConfig$java_lang_String;
    private boolean __MloadConfig$java_lang_String;
    private boolean __MgetCollector$java_lang_String$int$java_lang_String;
    private boolean __MgetAggregateFuntions;
    private boolean __MgetAggregate$java_lang_String;
    private boolean __McreateOutputInternal$org_ow2_jasmine_probe_JasmineOutput$boolean;
    private boolean __McreateIndicatorInternal$org_ow2_jasmine_probe_JasmineIndicator$boolean;
    private boolean __MgetNewProbeId;
    private boolean __MreadConfig;
    private boolean __MsaveConfigFile$java_io_OutputStream;
    private boolean __MloadConfigFile$java_io_InputStream;
    private boolean __MisOutputUsed$org_ow2_jasmine_probe_JasmineOutput$boolean;
    private boolean __MisTargetUsed$org_ow2_jasmine_probe_JasmineTarget;
    private boolean __MisIndicatorUsed$org_ow2_jasmine_probe_JasmineIndicator$boolean;
    private boolean __MsetProbeState$org_ow2_jasmine_probe_manager_JProbe$int$java_lang_String;
    private boolean __MstartWaitingProbes;
    private boolean __MgetRecursiveIndicatorList$org_ow2_jasmine_probe_JasmineProbe;

    ProbeConfig __getprobeConfig() {
        if (!this.__FprobeConfig) {
            return this.probeConfig;
        }
        return (ProbeConfig)this.__IM.onGet((Object)this, "probeConfig");
    }

    void __setprobeConfig(ProbeConfig probeConfig) {
        if (!this.__FprobeConfig) {
            this.probeConfig = probeConfig;
            return;
        }
        this.__IM.onSet((Object)this, "probeConfig", (Object)probeConfig);
    }

    Map __getprobes() {
        if (!this.__Fprobes) {
            return this.probes;
        }
        return (Map)this.__IM.onGet((Object)this, "probes");
    }

    void __setprobes(Map map) {
        if (!this.__Fprobes) {
            this.probes = map;
            return;
        }
        this.__IM.onSet((Object)this, "probes", (Object)map);
    }

    Map __getoutputs() {
        if (!this.__Foutputs) {
            return this.outputs;
        }
        return (Map)this.__IM.onGet((Object)this, "outputs");
    }

    void __setoutputs(Map map) {
        if (!this.__Foutputs) {
            this.outputs = map;
            return;
        }
        this.__IM.onSet((Object)this, "outputs", (Object)map);
    }

    Map __getindicators() {
        if (!this.__Findicators) {
            return this.indicators;
        }
        return (Map)this.__IM.onGet((Object)this, "indicators");
    }

    void __setindicators(Map map) {
        if (!this.__Findicators) {
            this.indicators = map;
            return;
        }
        this.__IM.onSet((Object)this, "indicators", (Object)map);
    }

    Map __gettargets() {
        if (!this.__Ftargets) {
            return this.targets;
        }
        return (Map)this.__IM.onGet((Object)this, "targets");
    }

    void __settargets(Map map) {
        if (!this.__Ftargets) {
            this.targets = map;
            return;
        }
        this.__IM.onSet((Object)this, "targets", (Object)map);
    }

    Map __getrunnings() {
        if (!this.__Frunnings) {
            return this.runnings;
        }
        return (Map)this.__IM.onGet((Object)this, "runnings");
    }

    void __setrunnings(Map map) {
        if (!this.__Frunnings) {
            this.runnings = map;
            return;
        }
        this.__IM.onSet((Object)this, "runnings", (Object)map);
    }

    Map __getouterservices() {
        if (!this.__Fouterservices) {
            return this.outerservices;
        }
        return (Map)this.__IM.onGet((Object)this, "outerservices");
    }

    void __setouterservices(Map map) {
        if (!this.__Fouterservices) {
            this.outerservices = map;
            return;
        }
        this.__IM.onSet((Object)this, "outerservices", (Object)map);
    }

    Map __getcollectorservices() {
        if (!this.__Fcollectorservices) {
            return this.collectorservices;
        }
        return (Map)this.__IM.onGet((Object)this, "collectorservices");
    }

    void __setcollectorservices(Map map) {
        if (!this.__Fcollectorservices) {
            this.collectorservices = map;
            return;
        }
        this.__IM.onSet((Object)this, "collectorservices", (Object)map);
    }

    Map __getaggregateservices() {
        if (!this.__Faggregateservices) {
            return this.aggregateservices;
        }
        return (Map)this.__IM.onGet((Object)this, "aggregateservices");
    }

    void __setaggregateservices(Map map) {
        if (!this.__Faggregateservices) {
            this.aggregateservices = map;
            return;
        }
        this.__IM.onSet((Object)this, "aggregateservices", (Object)map);
    }

    List __getprobeListeners() {
        if (!this.__FprobeListeners) {
            return this.probeListeners;
        }
        return (List)this.__IM.onGet((Object)this, "probeListeners");
    }

    void __setprobeListeners(List list) {
        if (!this.__FprobeListeners) {
            this.probeListeners = list;
            return;
        }
        this.__IM.onSet((Object)this, "probeListeners", (Object)list);
    }

    int __getprobeCount() {
        if (!this.__FprobeCount) {
            return this.probeCount;
        }
        Object object = this.__IM.onGet((Object)this, "probeCount");
        Integer n = (Integer)object;
        return n;
    }

    void __setprobeCount(int n) {
        if (!this.__FprobeCount) {
            this.probeCount = n;
            return;
        }
        Integer n2 = new Integer(n);
        this.__IM.onSet((Object)this, "probeCount", (Object)n2);
    }

    ObjectName __getmbeanObjectName() {
        if (!this.__FmbeanObjectName) {
            return this.mbeanObjectName;
        }
        return (ObjectName)this.__IM.onGet((Object)this, "mbeanObjectName");
    }

    void __setmbeanObjectName(ObjectName objectName) {
        if (!this.__FmbeanObjectName) {
            this.mbeanObjectName = objectName;
            return;
        }
        this.__IM.onSet((Object)this, "mbeanObjectName", (Object)objectName);
    }

    SchedulerService __getjasmineProbeScheduler() {
        if (!this.__FjasmineProbeScheduler) {
            return this.jasmineProbeScheduler;
        }
        return (SchedulerService)this.__IM.onGet((Object)this, "jasmineProbeScheduler");
    }

    void __setjasmineProbeScheduler(SchedulerService schedulerService) {
        if (!this.__FjasmineProbeScheduler) {
            this.jasmineProbeScheduler = schedulerService;
            return;
        }
        this.__IM.onSet((Object)this, "jasmineProbeScheduler", (Object)schedulerService);
    }

    JmxService __getjmxService() {
        if (!this.__FjmxService) {
            return this.jmxService;
        }
        return (JmxService)this.__IM.onGet((Object)this, "jmxService");
    }

    void __setjmxService(JmxService jmxService) {
        if (!this.__FjmxService) {
            this.jmxService = jmxService;
            return;
        }
        this.__IM.onSet((Object)this, "jmxService", (Object)jmxService);
    }

    public JProbeManager() {
        this(null);
    }

    private JProbeManager(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setprobeConfig(null);
        this.__setprobes(new HashMap());
        this.__setoutputs(new HashMap());
        this.__setindicators(new HashMap());
        this.__settargets(new HashMap());
        this.__setrunnings(new HashMap());
        this.__setouterservices(new HashMap());
        this.__setcollectorservices(new HashMap());
        this.__setaggregateservices(new HashMap());
        this.__setprobeListeners(new ArrayList());
        this.__setprobeCount(0);
        this.__setmbeanObjectName(null);
        this.__setjasmineProbeScheduler(null);
        this.__setjmxService(null);
    }

    public void start() {
        if (!this.__Mstart) {
            this.__start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    @Validate
    private void __start() {
        logger.debug((Object)"JasmineProbeManager service activated.", new Object[0]);
        try {
            this.readConfig();
        }
        catch (Exception e) {
            logger.error((Object)"Cannot read configuration", new Object[0]);
        }
        try {
            this.__setmbeanObjectName(new ObjectName("jasmine:dest=probe-manager"));
            this.__getjmxService().registerMBean((Object)this, this.__getmbeanObjectName());
        }
        catch (Exception e) {
            logger.error((Object)("Cannot register mbean: " + e), new Object[0]);
        }
    }

    public void stop() {
        if (!this.__Mstop) {
            this.__stop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop", new Object[0]);
            this.__stop();
            this.__IM.onExit((Object)this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop", throwable);
            throw throwable;
        }
    }

    @Invalidate
    private void __stop() {
        logger.debug((Object)"JasmineProbeManager service stopped.", new Object[0]);
        this.__getjmxService().unregisterMBean(this.__getmbeanObjectName());
    }

    protected void bindOuterService(JasmineOuterService jasmineOuterService, ServiceReference serviceReference) {
        if (!this.__MbindOuterService$org_ow2_jasmine_probe_outer_JasmineOuterService$org_osgi_framework_ServiceReference) {
            this.__bindOuterService(jasmineOuterService, serviceReference);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "bindOuterService$org_ow2_jasmine_probe_outer_JasmineOuterService$org_osgi_framework_ServiceReference", new Object[]{jasmineOuterService, serviceReference});
            this.__bindOuterService(jasmineOuterService, serviceReference);
            this.__IM.onExit((Object)this, "bindOuterService$org_ow2_jasmine_probe_outer_JasmineOuterService$org_osgi_framework_ServiceReference", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "bindOuterService$org_ow2_jasmine_probe_outer_JasmineOuterService$org_osgi_framework_ServiceReference", throwable);
            throw throwable;
        }
    }

    @Bind(aggregate=true, optional=true)
    private void __bindOuterService(JasmineOuterService jos, ServiceReference sr) {
        String type = (String)sr.getProperty("output.type");
        if (type == null) {
            logger.warn((Object)"JasmineOuterService with undefined output.type", new Object[0]);
            return;
        }
        JasmineOuterService old = (JasmineOuterService)this.__getouterservices().get(type);
        if (old != null) {
            logger.warn((Object)("JasmineOuterService already defined for " + type), new Object[0]);
            return;
        }
        this.__getouterservices().put(type, jos);
        logger.info((Object)"{0} JasmineOuterService bound into JasmineProbe.", new Object[]{type});
        this.startWaitingProbes();
    }

    protected void unbindOuterService(JasmineOuterService jasmineOuterService, ServiceReference serviceReference) {
        if (!this.__MunbindOuterService$org_ow2_jasmine_probe_outer_JasmineOuterService$org_osgi_framework_ServiceReference) {
            this.__unbindOuterService(jasmineOuterService, serviceReference);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "unbindOuterService$org_ow2_jasmine_probe_outer_JasmineOuterService$org_osgi_framework_ServiceReference", new Object[]{jasmineOuterService, serviceReference});
            this.__unbindOuterService(jasmineOuterService, serviceReference);
            this.__IM.onExit((Object)this, "unbindOuterService$org_ow2_jasmine_probe_outer_JasmineOuterService$org_osgi_framework_ServiceReference", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "unbindOuterService$org_ow2_jasmine_probe_outer_JasmineOuterService$org_osgi_framework_ServiceReference", throwable);
            throw throwable;
        }
    }

    @Unbind(aggregate=true, optional=true)
    private void __unbindOuterService(JasmineOuterService jos, ServiceReference sr) {
    }

    protected void bindCollectorService(JasmineCollectorService jasmineCollectorService, ServiceReference serviceReference) {
        if (!this.__MbindCollectorService$org_ow2_jasmine_probe_collector_JasmineCollectorService$org_osgi_framework_ServiceReference) {
            this.__bindCollectorService(jasmineCollectorService, serviceReference);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "bindCollectorService$org_ow2_jasmine_probe_collector_JasmineCollectorService$org_osgi_framework_ServiceReference", new Object[]{jasmineCollectorService, serviceReference});
            this.__bindCollectorService(jasmineCollectorService, serviceReference);
            this.__IM.onExit((Object)this, "bindCollectorService$org_ow2_jasmine_probe_collector_JasmineCollectorService$org_osgi_framework_ServiceReference", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "bindCollectorService$org_ow2_jasmine_probe_collector_JasmineCollectorService$org_osgi_framework_ServiceReference", throwable);
            throw throwable;
        }
    }

    @Bind(aggregate=true, optional=true)
    private void __bindCollectorService(JasmineCollectorService jcs, ServiceReference sr) {
        String type = (String)sr.getProperty("indicator.type");
        if (type == null) {
            logger.warn((Object)"JasmineCollectorService with undefined indicator.type", new Object[0]);
            return;
        }
        JasmineCollectorService old = (JasmineCollectorService)this.__getcollectorservices().get(type);
        if (old != null) {
            logger.warn((Object)("JasmineCollectorService already defined for " + type), new Object[0]);
            return;
        }
        this.__getcollectorservices().put(type, jcs);
        logger.info((Object)"{0} JasmineCollectorService bound into JasmineProbe.", new Object[]{type});
        this.startWaitingProbes();
    }

    protected void unbindCollectorService(JasmineCollectorService jasmineCollectorService, ServiceReference serviceReference) {
        if (!this.__MunbindCollectorService$org_ow2_jasmine_probe_collector_JasmineCollectorService$org_osgi_framework_ServiceReference) {
            this.__unbindCollectorService(jasmineCollectorService, serviceReference);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "unbindCollectorService$org_ow2_jasmine_probe_collector_JasmineCollectorService$org_osgi_framework_ServiceReference", new Object[]{jasmineCollectorService, serviceReference});
            this.__unbindCollectorService(jasmineCollectorService, serviceReference);
            this.__IM.onExit((Object)this, "unbindCollectorService$org_ow2_jasmine_probe_collector_JasmineCollectorService$org_osgi_framework_ServiceReference", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "unbindCollectorService$org_ow2_jasmine_probe_collector_JasmineCollectorService$org_osgi_framework_ServiceReference", throwable);
            throw throwable;
        }
    }

    @Unbind(aggregate=true, optional=true)
    private void __unbindCollectorService(JasmineCollectorService jcs, ServiceReference sr) {
    }

    protected void bindAggregateService(JasmineAggregateService jasmineAggregateService, ServiceReference serviceReference) {
        if (!this.__MbindAggregateService$org_ow2_jasmine_probe_collector_JasmineAggregateService$org_osgi_framework_ServiceReference) {
            this.__bindAggregateService(jasmineAggregateService, serviceReference);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "bindAggregateService$org_ow2_jasmine_probe_collector_JasmineAggregateService$org_osgi_framework_ServiceReference", new Object[]{jasmineAggregateService, serviceReference});
            this.__bindAggregateService(jasmineAggregateService, serviceReference);
            this.__IM.onExit((Object)this, "bindAggregateService$org_ow2_jasmine_probe_collector_JasmineAggregateService$org_osgi_framework_ServiceReference", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "bindAggregateService$org_ow2_jasmine_probe_collector_JasmineAggregateService$org_osgi_framework_ServiceReference", throwable);
            throw throwable;
        }
    }

    @Bind(aggregate=true, optional=true)
    private void __bindAggregateService(JasmineAggregateService jas, ServiceReference sr) {
        String type = (String)sr.getProperty("aggregate.type");
        if (type == null) {
            logger.warn((Object)"JasmineAggregateService with undefined aggregate.type binded", new Object[0]);
            return;
        }
        JasmineAggregateService old = (JasmineAggregateService)this.__getaggregateservices().get(type);
        if (old != null) {
            logger.warn((Object)("AggregateService already defined for " + type + " function. Please check deployment plan and undeploy old service !"), new Object[0]);
            return;
        }
        this.__getaggregateservices().put(type, jas);
        logger.info((Object)"{0} JasmineAggregateService bound into JasmineProbe.", new Object[]{type});
    }

    protected void unbindAggregateService(JasmineAggregateService jasmineAggregateService, ServiceReference serviceReference) {
        if (!this.__MunbindAggregateService$org_ow2_jasmine_probe_collector_JasmineAggregateService$org_osgi_framework_ServiceReference) {
            this.__unbindAggregateService(jasmineAggregateService, serviceReference);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "unbindAggregateService$org_ow2_jasmine_probe_collector_JasmineAggregateService$org_osgi_framework_ServiceReference", new Object[]{jasmineAggregateService, serviceReference});
            this.__unbindAggregateService(jasmineAggregateService, serviceReference);
            this.__IM.onExit((Object)this, "unbindAggregateService$org_ow2_jasmine_probe_collector_JasmineAggregateService$org_osgi_framework_ServiceReference", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "unbindAggregateService$org_ow2_jasmine_probe_collector_JasmineAggregateService$org_osgi_framework_ServiceReference", throwable);
            throw throwable;
        }
    }

    @Unbind(aggregate=true, optional=true)
    private void __unbindAggregateService(JasmineAggregateService jas, ServiceReference sr) {
        String type = (String)sr.getProperty("aggregate.type");
        if (type == null) {
            logger.warn((Object)"JasmineAggregateService with undefined aggregate.type unbinded", new Object[0]);
            return;
        }
        if (this.__getaggregateservices().containsKey(type)) {
            this.__getaggregateservices().remove(type);
            logger.info((Object)"{0} JasmineAggregateService unbound into JasmineProbe.", new Object[]{type});
        }
    }

    public SchedulerService getScheduler() {
        SchedulerService schedulerService;
        if (!this.__MgetScheduler) {
            return this.__getScheduler();
        }
        try {
            this.__IM.onEntry((Object)this, "getScheduler", new Object[0]);
            schedulerService = this.__getScheduler();
            this.__IM.onExit((Object)this, "getScheduler", (Object)schedulerService);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getScheduler", throwable);
            throw throwable;
        }
        return schedulerService;
    }

    private SchedulerService __getScheduler() {
        return this.__getjasmineProbeScheduler();
    }

    public JasmineOuterService getOuterService(String string) {
        JasmineOuterService jasmineOuterService;
        if (!this.__MgetOuterService$java_lang_String) {
            return this.__getOuterService(string);
        }
        try {
            this.__IM.onEntry((Object)this, "getOuterService$java_lang_String", new Object[]{string});
            jasmineOuterService = this.__getOuterService(string);
            this.__IM.onExit((Object)this, "getOuterService$java_lang_String", (Object)jasmineOuterService);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getOuterService$java_lang_String", throwable);
            throw throwable;
        }
        return jasmineOuterService;
    }

    private JasmineOuterService __getOuterService(String type) {
        return (JasmineOuterService)this.__getouterservices().get(type);
    }

    public JasmineCollectorService getCollectorService(String string) {
        JasmineCollectorService jasmineCollectorService;
        if (!this.__MgetCollectorService$java_lang_String) {
            return this.__getCollectorService(string);
        }
        try {
            this.__IM.onEntry((Object)this, "getCollectorService$java_lang_String", new Object[]{string});
            jasmineCollectorService = this.__getCollectorService(string);
            this.__IM.onExit((Object)this, "getCollectorService$java_lang_String", (Object)jasmineCollectorService);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getCollectorService$java_lang_String", throwable);
            throw throwable;
        }
        return jasmineCollectorService;
    }

    private JasmineCollectorService __getCollectorService(String type) {
        return (JasmineCollectorService)this.__getcollectorservices().get(type);
    }

    public synchronized String createProbe(JasmineProbe jasmineProbe) throws JasmineProbeException {
        String string;
        if (!this.__McreateProbe$org_ow2_jasmine_probe_JasmineProbe) {
            return this.__createProbe(jasmineProbe);
        }
        try {
            this.__IM.onEntry((Object)this, "createProbe$org_ow2_jasmine_probe_JasmineProbe", new Object[]{jasmineProbe});
            string = this.__createProbe(jasmineProbe);
            this.__IM.onExit((Object)this, "createProbe$org_ow2_jasmine_probe_JasmineProbe", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "createProbe$org_ow2_jasmine_probe_JasmineProbe", throwable);
            throw throwable;
        }
        return string;
    }

    private String __createProbe(JasmineProbe probe) throws JasmineProbeException {
        String id = probe.getId();
        if (id == null) {
            id = this.getNewProbeId();
            probe.setId(id);
        } else {
            for (JasmineProbe p : this.__getprobes().values()) {
                if (!p.getId().equals(id)) continue;
                logger.error((Object)("Id already used: " + id), new Object[0]);
                throw new JasmineProbeException("Id already used");
            }
        }
        if (probe.getIndicatorList().isEmpty()) {
            throw new JasmineProbeException("A probe must have at least one indicator");
        }
        if (probe.getOutputList().isEmpty()) {
            throw new JasmineProbeException("A probe must have at least one output");
        }
        logger.debug((Object)("creating probe : " + id), new Object[0]);
        this.__getprobes().put(id, probe);
        return id;
    }

    public synchronized void removeProbe(String string) throws JasmineProbeException {
        if (!this.__MremoveProbe$java_lang_String) {
            this.__removeProbe(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "removeProbe$java_lang_String", new Object[]{string});
            this.__removeProbe(string);
            this.__IM.onExit((Object)this, "removeProbe$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "removeProbe$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __removeProbe(String probeId) throws JasmineProbeException {
        JasmineProbe def = (JasmineProbe)this.__getprobes().get(probeId);
        if (def == null) {
            throw new JasmineProbeException("Cannot remove probe with unexistent id " + probeId);
        }
        JProbe running = (JProbe)this.__getrunnings().get(probeId);
        if (running != null) {
            running.suspend();
            this.__getrunnings().remove(probeId);
        }
        logger.debug((Object)("removing probe " + probeId), new Object[0]);
        this.__getprobes().remove(probeId);
    }

    public synchronized void removeAllProbes() throws JasmineProbeException {
        if (!this.__MremoveAllProbes) {
            this.__removeAllProbes();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "removeAllProbes", new Object[0]);
            this.__removeAllProbes();
            this.__IM.onExit((Object)this, "removeAllProbes", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "removeAllProbes", throwable);
            throw throwable;
        }
    }

    private void __removeAllProbes() throws JasmineProbeException {
        logger.debug((Object)"", new Object[0]);
        ArrayList<String> namelist = new ArrayList<String>();
        for (String n : this.__getprobes().keySet()) {
            namelist.add(n);
        }
        for (String name : namelist) {
            this.removeProbe(name);
        }
    }

    public synchronized List<JasmineProbe> getProbes() {
        List<JasmineProbe> list;
        if (!this.__MgetProbes) {
            return this.__getProbes();
        }
        try {
            this.__IM.onEntry((Object)this, "getProbes", new Object[0]);
            list = this.__getProbes();
            this.__IM.onExit((Object)this, "getProbes", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getProbes", throwable);
            throw throwable;
        }
        return list;
    }

    private List<JasmineProbe> __getProbes() {
        logger.debug((Object)"", new Object[0]);
        ArrayList<JasmineProbe> ret = new ArrayList<JasmineProbe>();
        ret.addAll(this.__getprobes().values());
        return ret;
    }

    public synchronized String[] listProbes() {
        String[] stringArray;
        if (!this.__MlistProbes) {
            return this.__listProbes();
        }
        try {
            this.__IM.onEntry((Object)this, "listProbes", new Object[0]);
            stringArray = this.__listProbes();
            this.__IM.onExit((Object)this, "listProbes", (Object)stringArray);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "listProbes", throwable);
            throw throwable;
        }
        return stringArray;
    }

    private String[] __listProbes() {
        logger.debug((Object)"", new Object[0]);
        ArrayList<String> ret = new ArrayList<String>();
        for (String n : this.__getprobes().keySet()) {
            ret.add(n);
        }
        return ret.toArray(new String[0]);
    }

    public synchronized JasmineProbe getProbe(String string) throws JasmineProbeException {
        JasmineProbe jasmineProbe;
        if (!this.__MgetProbe$java_lang_String) {
            return this.__getProbe(string);
        }
        try {
            this.__IM.onEntry((Object)this, "getProbe$java_lang_String", new Object[]{string});
            jasmineProbe = this.__getProbe(string);
            this.__IM.onExit((Object)this, "getProbe$java_lang_String", (Object)jasmineProbe);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getProbe$java_lang_String", throwable);
            throw throwable;
        }
        return jasmineProbe;
    }

    private JasmineProbe __getProbe(String probeId) throws JasmineProbeException {
        JasmineProbe def = (JasmineProbe)this.__getprobes().get(probeId);
        if (def == null) {
            throw new JasmineProbeException("Cannot find probe with id " + probeId);
        }
        return def;
    }

    public synchronized void startProbe(String string) throws JasmineProbeException {
        if (!this.__MstartProbe$java_lang_String) {
            this.__startProbe(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "startProbe$java_lang_String", new Object[]{string});
            this.__startProbe(string);
            this.__IM.onExit((Object)this, "startProbe$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "startProbe$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __startProbe(String probeId) throws JasmineProbeException {
        JasmineProbe def = (JasmineProbe)this.__getprobes().get(probeId);
        if (def == null) {
            throw new JasmineProbeException("Cannot start probe with unexistent id " + probeId);
        }
        JProbe running = (JProbe)this.__getrunnings().get(probeId);
        if (running != null) {
            switch (running.getStatus()) {
                case 2: {
                    logger.info((Object)("Probe already running: " + probeId), new Object[0]);
                    return;
                }
                case 1: {
                    logger.info((Object)("Probe already started: " + probeId), new Object[0]);
                    return;
                }
                case 3: {
                    logger.info((Object)("restarting a failed probe: " + probeId), new Object[0]);
                    break;
                }
                case 0: {
                    logger.info((Object)("restarting a stopped probe: " + probeId), new Object[0]);
                    break;
                }
                default: {
                    logger.warn((Object)("Bad state for: " + probeId), new Object[0]);
                    break;
                }
            }
        } else {
            running = new JProbe(def, this);
            this.__getrunnings().put(probeId, running);
        }
        running.resume();
    }

    public synchronized void stopProbe(String string) throws JasmineProbeException {
        if (!this.__MstopProbe$java_lang_String) {
            this.__stopProbe(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stopProbe$java_lang_String", new Object[]{string});
            this.__stopProbe(string);
            this.__IM.onExit((Object)this, "stopProbe$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stopProbe$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __stopProbe(String probeId) throws JasmineProbeException {
        JasmineProbe def = (JasmineProbe)this.__getprobes().get(probeId);
        if (def == null) {
            throw new JasmineProbeException("Cannot start probe with unexistent id " + probeId);
        }
        JProbe running = (JProbe)this.__getrunnings().get(probeId);
        if (running == null) {
            throw new JasmineProbeException("This probe is not running: " + probeId);
        }
        running.suspend();
    }

    public synchronized void startAllProbes() throws JasmineProbeException {
        if (!this.__MstartAllProbes) {
            this.__startAllProbes();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "startAllProbes", new Object[0]);
            this.__startAllProbes();
            this.__IM.onExit((Object)this, "startAllProbes", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "startAllProbes", throwable);
            throw throwable;
        }
    }

    private void __startAllProbes() throws JasmineProbeException {
        for (JasmineProbe probe : this.__getprobes().values()) {
            try {
                this.startProbe(probe.getId());
            }
            catch (Exception e) {
                logger.warn((Object)("could not start probe " + probe.getId() + " :" + e), new Object[0]);
            }
        }
    }

    public synchronized void stopAllProbes() throws JasmineProbeException {
        if (!this.__MstopAllProbes) {
            this.__stopAllProbes();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stopAllProbes", new Object[0]);
            this.__stopAllProbes();
            this.__IM.onExit((Object)this, "stopAllProbes", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stopAllProbes", throwable);
            throw throwable;
        }
    }

    private void __stopAllProbes() throws JasmineProbeException {
        for (JProbe probe : this.__getrunnings().values()) {
            try {
                probe.suspend();
            }
            catch (Exception e) {
                logger.warn((Object)("could not stop probe " + probe.getProbeDef().getId() + " :" + e), new Object[0]);
            }
        }
    }

    public synchronized void changeProbe(JasmineProbe jasmineProbe) throws JasmineProbeException {
        if (!this.__MchangeProbe$org_ow2_jasmine_probe_JasmineProbe) {
            this.__changeProbe(jasmineProbe);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "changeProbe$org_ow2_jasmine_probe_JasmineProbe", new Object[]{jasmineProbe});
            this.__changeProbe(jasmineProbe);
            this.__IM.onExit((Object)this, "changeProbe$org_ow2_jasmine_probe_JasmineProbe", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "changeProbe$org_ow2_jasmine_probe_JasmineProbe", throwable);
            throw throwable;
        }
    }

    private void __changeProbe(JasmineProbe newdef) throws JasmineProbeException {
        String probeId = newdef.getId();
        JasmineProbe olddef = (JasmineProbe)this.__getprobes().get(probeId);
        if (olddef == null) {
            throw new JasmineProbeException("Probe not found: " + probeId);
        }
        boolean restart = false;
        JProbe running = (JProbe)this.__getrunnings().get(probeId);
        if (running != null) {
            running.suspend();
            restart = true;
        }
        if (newdef.getPeriod() > 0) {
            olddef.setPeriod(newdef.getPeriod());
        }
        if (newdef.getOutputList().size() > 0) {
            olddef.setOutputList(newdef.getOutputList());
        }
        if (newdef.getIndicatorList().size() > 0) {
            olddef.setIndicatorList(newdef.getIndicatorList());
        }
        if (newdef.getTargetList().size() > 0) {
            olddef.setTargetList(newdef.getTargetList());
        }
        if (restart) {
            running.resume();
        }
    }

    public String createOutput(JasmineOutput jasmineOutput) throws JasmineProbeException {
        String string;
        if (!this.__McreateOutput$org_ow2_jasmine_probe_JasmineOutput) {
            return this.__createOutput(jasmineOutput);
        }
        try {
            this.__IM.onEntry((Object)this, "createOutput$org_ow2_jasmine_probe_JasmineOutput", new Object[]{jasmineOutput});
            string = this.__createOutput(jasmineOutput);
            this.__IM.onExit((Object)this, "createOutput$org_ow2_jasmine_probe_JasmineOutput", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "createOutput$org_ow2_jasmine_probe_JasmineOutput", throwable);
            throw throwable;
        }
        return string;
    }

    private String __createOutput(JasmineOutput newoutput) throws JasmineProbeException {
        return this.createOutputInternal(newoutput, true);
    }

    public void changeOutput(JasmineOutput jasmineOutput) throws JasmineProbeException {
        if (!this.__MchangeOutput$org_ow2_jasmine_probe_JasmineOutput) {
            this.__changeOutput(jasmineOutput);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "changeOutput$org_ow2_jasmine_probe_JasmineOutput", new Object[]{jasmineOutput});
            this.__changeOutput(jasmineOutput);
            this.__IM.onExit((Object)this, "changeOutput$org_ow2_jasmine_probe_JasmineOutput", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "changeOutput$org_ow2_jasmine_probe_JasmineOutput", throwable);
            throw throwable;
        }
    }

    private void __changeOutput(JasmineOutput newdef) throws JasmineProbeException {
        logger.debug((Object)"", new Object[0]);
        String name = newdef.getName();
        JasmineOutput output = (JasmineOutput)this.__getoutputs().get(name);
        if (output == null) {
            throw new JasmineProbeException("This output does not exist: " + name);
        }
        ArrayList<JProbe> prlist = new ArrayList<JProbe>();
        block0: for (JProbe running : this.__getrunnings().values()) {
            JasmineProbe probe = running.getProbeDef();
            for (String oname : probe.getOutputList()) {
                if (!oname.equals(name)) continue;
                running.suspend();
                prlist.add(running);
                continue block0;
            }
        }
        JasmineOuterService jos = (JasmineOuterService)this.__getouterservices().get(output.getType());
        if (jos != null) {
            jos.removeOuters(name);
        }
        if (newdef.getType() != null) {
            output.setType(newdef.getType());
        }
        for (String key : newdef.getProperties().keySet()) {
            String newval = (String)newdef.getProperties().get(key);
            String oldval = (String)output.getProperties().get(key);
            if (oldval != null) {
                output.getProperties().remove(key);
            }
            output.getProperties().put(key, newval);
        }
        for (JProbe running : prlist) {
            running.resume();
        }
    }

    public void removeOutput(String string) throws JasmineProbeException {
        if (!this.__MremoveOutput$java_lang_String) {
            this.__removeOutput(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "removeOutput$java_lang_String", new Object[]{string});
            this.__removeOutput(string);
            this.__IM.onExit((Object)this, "removeOutput$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "removeOutput$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __removeOutput(String name) throws JasmineProbeException {
        logger.debug((Object)"", new Object[0]);
        JasmineOutput output = (JasmineOutput)this.__getoutputs().get(name);
        if (output == null) {
            throw new JasmineProbeException("This output does not exist: " + name);
        }
        if (this.isOutputUsed(output, true)) {
            throw new JasmineProbeException("This output is used and cannot be removed: " + name);
        }
        JasmineOuterService jos = (JasmineOuterService)this.__getouterservices().get(output.getType());
        if (jos != null) {
            jos.removeOuters(name);
        }
        this.__getoutputs().remove(name);
    }

    public synchronized String[] listOutputs() {
        String[] stringArray;
        if (!this.__MlistOutputs) {
            return this.__listOutputs();
        }
        try {
            this.__IM.onEntry((Object)this, "listOutputs", new Object[0]);
            stringArray = this.__listOutputs();
            this.__IM.onExit((Object)this, "listOutputs", (Object)stringArray);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "listOutputs", throwable);
            throw throwable;
        }
        return stringArray;
    }

    private String[] __listOutputs() {
        logger.debug((Object)"", new Object[0]);
        ArrayList<String> ret = new ArrayList<String>();
        for (JasmineOutput output : this.__getoutputs().values()) {
            ret.add(output.getName());
        }
        return ret.toArray(new String[0]);
    }

    public synchronized List<JasmineOutput> getOutputs() {
        List<JasmineOutput> list;
        if (!this.__MgetOutputs) {
            return this.__getOutputs();
        }
        try {
            this.__IM.onEntry((Object)this, "getOutputs", new Object[0]);
            list = this.__getOutputs();
            this.__IM.onExit((Object)this, "getOutputs", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getOutputs", throwable);
            throw throwable;
        }
        return list;
    }

    private List<JasmineOutput> __getOutputs() {
        logger.debug((Object)"", new Object[0]);
        ArrayList<JasmineOutput> ret = new ArrayList<JasmineOutput>();
        ret.addAll(this.__getoutputs().values());
        return ret;
    }

    public synchronized JasmineOutput getOutput(String string) throws JasmineProbeException {
        JasmineOutput jasmineOutput;
        if (!this.__MgetOutput$java_lang_String) {
            return this.__getOutput(string);
        }
        try {
            this.__IM.onEntry((Object)this, "getOutput$java_lang_String", new Object[]{string});
            jasmineOutput = this.__getOutput(string);
            this.__IM.onExit((Object)this, "getOutput$java_lang_String", (Object)jasmineOutput);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getOutput$java_lang_String", throwable);
            throw throwable;
        }
        return jasmineOutput;
    }

    private JasmineOutput __getOutput(String id) throws JasmineProbeException {
        logger.debug((Object)"", new Object[0]);
        JasmineOutput def = (JasmineOutput)this.__getoutputs().get(id);
        if (def == null) {
            throw new JasmineProbeException("Cannot find output with id " + id);
        }
        return def;
    }

    public List<JasminePropertyInfo> getOutputPropertyInfos(String string) {
        List<JasminePropertyInfo> list;
        if (!this.__MgetOutputPropertyInfos$java_lang_String) {
            return this.__getOutputPropertyInfos(string);
        }
        try {
            this.__IM.onEntry((Object)this, "getOutputPropertyInfos$java_lang_String", new Object[]{string});
            list = this.__getOutputPropertyInfos(string);
            this.__IM.onExit((Object)this, "getOutputPropertyInfos$java_lang_String", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getOutputPropertyInfos$java_lang_String", throwable);
            throw throwable;
        }
        return list;
    }

    private List<JasminePropertyInfo> __getOutputPropertyInfos(String type) {
        JasmineOuterService jos = (JasmineOuterService)this.__getouterservices().get(type);
        if (jos == null) {
            logger.error((Object)("No OuterService found for type " + type), new Object[0]);
            return null;
        }
        return jos.getPropertiesInfo();
    }

    public synchronized Set<String> getOutputTypes() {
        Set<String> set;
        if (!this.__MgetOutputTypes) {
            return this.__getOutputTypes();
        }
        try {
            this.__IM.onEntry((Object)this, "getOutputTypes", new Object[0]);
            set = this.__getOutputTypes();
            this.__IM.onExit((Object)this, "getOutputTypes", set);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getOutputTypes", throwable);
            throw throwable;
        }
        return set;
    }

    private Set<String> __getOutputTypes() {
        return this.__getouterservices().keySet();
    }

    public synchronized Set<String> getOutputCurrentUse(String string) throws JasmineProbeException {
        Set<String> set;
        if (!this.__MgetOutputCurrentUse$java_lang_String) {
            return this.__getOutputCurrentUse(string);
        }
        try {
            this.__IM.onEntry((Object)this, "getOutputCurrentUse$java_lang_String", new Object[]{string});
            set = this.__getOutputCurrentUse(string);
            this.__IM.onExit((Object)this, "getOutputCurrentUse$java_lang_String", set);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getOutputCurrentUse$java_lang_String", throwable);
            throw throwable;
        }
        return set;
    }

    private Set<String> __getOutputCurrentUse(String name) throws JasmineProbeException {
        HashSet<String> ret = new HashSet<String>();
        for (JasmineProbe probe : this.__getprobes().values()) {
            for (String output : probe.getOutputList()) {
                if (!output.equals(name)) continue;
                ret.add(probe.getId());
            }
        }
        return ret;
    }

    public String createIndicator(JasmineIndicator jasmineIndicator) throws JasmineProbeException {
        String string;
        if (!this.__McreateIndicator$org_ow2_jasmine_probe_JasmineIndicator) {
            return this.__createIndicator(jasmineIndicator);
        }
        try {
            this.__IM.onEntry((Object)this, "createIndicator$org_ow2_jasmine_probe_JasmineIndicator", new Object[]{jasmineIndicator});
            string = this.__createIndicator(jasmineIndicator);
            this.__IM.onExit((Object)this, "createIndicator$org_ow2_jasmine_probe_JasmineIndicator", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "createIndicator$org_ow2_jasmine_probe_JasmineIndicator", throwable);
            throw throwable;
        }
        return string;
    }

    private String __createIndicator(JasmineIndicator newindic) throws JasmineProbeException {
        return this.createIndicatorInternal(newindic, true);
    }

    public void changeIndicator(JasmineIndicator jasmineIndicator) throws JasmineProbeException {
        if (!this.__MchangeIndicator$org_ow2_jasmine_probe_JasmineIndicator) {
            this.__changeIndicator(jasmineIndicator);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "changeIndicator$org_ow2_jasmine_probe_JasmineIndicator", new Object[]{jasmineIndicator});
            this.__changeIndicator(jasmineIndicator);
            this.__IM.onExit((Object)this, "changeIndicator$org_ow2_jasmine_probe_JasmineIndicator", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "changeIndicator$org_ow2_jasmine_probe_JasmineIndicator", throwable);
            throw throwable;
        }
    }

    private void __changeIndicator(JasmineIndicator newdef) throws JasmineProbeException {
        logger.debug((Object)"", new Object[0]);
        String name = newdef.getName();
        JasmineIndicator indic = (JasmineIndicator)this.__getindicators().get(name);
        if (indic == null) {
            throw new JasmineProbeException("This indcator does not exist: " + name);
        }
        ArrayList<JProbe> prlist = new ArrayList<JProbe>();
        block0: for (JProbe running : this.__getrunnings().values()) {
            JasmineProbe probe = running.getProbeDef();
            for (String oname : probe.getIndicatorList()) {
                if (!oname.equals(name)) continue;
                running.suspend();
                prlist.add(running);
                continue block0;
            }
        }
        JasmineCollectorService jcs = (JasmineCollectorService)this.__getcollectorservices().get(indic.getType());
        if (jcs != null) {
            jcs.removeCollectors(name);
        }
        if (newdef.getType() != null) {
            indic.setType(newdef.getType());
        }
        for (String key : newdef.getProperties().keySet()) {
            String newval = (String)newdef.getProperties().get(key);
            String oldval = (String)indic.getProperties().get(key);
            if (oldval != null) {
                indic.getProperties().remove(key);
            }
            indic.getProperties().put(key, newval);
        }
        for (JProbe running : prlist) {
            running.resume();
        }
    }

    public void removeIndicator(String string) throws JasmineProbeException {
        if (!this.__MremoveIndicator$java_lang_String) {
            this.__removeIndicator(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "removeIndicator$java_lang_String", new Object[]{string});
            this.__removeIndicator(string);
            this.__IM.onExit((Object)this, "removeIndicator$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "removeIndicator$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __removeIndicator(String name) throws JasmineProbeException {
        logger.debug((Object)"", new Object[0]);
        JasmineIndicator indic = (JasmineIndicator)this.__getindicators().get(name);
        if (indic == null) {
            throw new JasmineProbeException("This indicator does not exist: " + name);
        }
        if (this.isIndicatorUsed(indic, true)) {
            throw new JasmineProbeException("This indicator is used and cannot be removed: " + name);
        }
        JasmineCollectorService jcs = (JasmineCollectorService)this.__getcollectorservices().get(indic.getType());
        if (jcs != null) {
            jcs.removeCollectors(name);
        }
        this.__getindicators().remove(name);
    }

    public synchronized JasmineIndicator getIndicator(String string) throws JasmineProbeException {
        JasmineIndicator jasmineIndicator;
        if (!this.__MgetIndicator$java_lang_String) {
            return this.__getIndicator(string);
        }
        try {
            this.__IM.onEntry((Object)this, "getIndicator$java_lang_String", new Object[]{string});
            jasmineIndicator = this.__getIndicator(string);
            this.__IM.onExit((Object)this, "getIndicator$java_lang_String", (Object)jasmineIndicator);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getIndicator$java_lang_String", throwable);
            throw throwable;
        }
        return jasmineIndicator;
    }

    private JasmineIndicator __getIndicator(String id) throws JasmineProbeException {
        logger.debug((Object)"", new Object[0]);
        JasmineIndicator def = (JasmineIndicator)this.__getindicators().get(id);
        if (def == null) {
            throw new JasmineProbeException("Cannot find indicator with id " + id);
        }
        return def;
    }

    public synchronized List<JasmineIndicator> getIndicators() {
        List<JasmineIndicator> list;
        if (!this.__MgetIndicators) {
            return this.__getIndicators();
        }
        try {
            this.__IM.onEntry((Object)this, "getIndicators", new Object[0]);
            list = this.__getIndicators();
            this.__IM.onExit((Object)this, "getIndicators", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getIndicators", throwable);
            throw throwable;
        }
        return list;
    }

    private List<JasmineIndicator> __getIndicators() {
        logger.debug((Object)"", new Object[0]);
        ArrayList<JasmineIndicator> ret = new ArrayList<JasmineIndicator>();
        ret.addAll(this.__getindicators().values());
        return ret;
    }

    public synchronized String[] listIndicators() {
        String[] stringArray;
        if (!this.__MlistIndicators) {
            return this.__listIndicators();
        }
        try {
            this.__IM.onEntry((Object)this, "listIndicators", new Object[0]);
            stringArray = this.__listIndicators();
            this.__IM.onExit((Object)this, "listIndicators", (Object)stringArray);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "listIndicators", throwable);
            throw throwable;
        }
        return stringArray;
    }

    private String[] __listIndicators() {
        logger.debug((Object)"", new Object[0]);
        ArrayList<String> ret = new ArrayList<String>();
        for (JasmineIndicator indic : this.__getindicators().values()) {
            ret.add(indic.getName());
        }
        return ret.toArray(new String[0]);
    }

    public List<JasminePropertyInfo> getIndicatorPropertyInfos(String string) {
        List<JasminePropertyInfo> list;
        if (!this.__MgetIndicatorPropertyInfos$java_lang_String) {
            return this.__getIndicatorPropertyInfos(string);
        }
        try {
            this.__IM.onEntry((Object)this, "getIndicatorPropertyInfos$java_lang_String", new Object[]{string});
            list = this.__getIndicatorPropertyInfos(string);
            this.__IM.onExit((Object)this, "getIndicatorPropertyInfos$java_lang_String", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getIndicatorPropertyInfos$java_lang_String", throwable);
            throw throwable;
        }
        return list;
    }

    private List<JasminePropertyInfo> __getIndicatorPropertyInfos(String type) {
        JasmineCollectorService jcs = (JasmineCollectorService)this.__getcollectorservices().get(type);
        if (jcs == null) {
            logger.error((Object)("No CollectorService found for type " + type), new Object[0]);
            return null;
        }
        return jcs.getPropertiesInfo();
    }

    public synchronized Set<String> getIndicatorTypes() {
        Set<String> set;
        if (!this.__MgetIndicatorTypes) {
            return this.__getIndicatorTypes();
        }
        try {
            this.__IM.onEntry((Object)this, "getIndicatorTypes", new Object[0]);
            set = this.__getIndicatorTypes();
            this.__IM.onExit((Object)this, "getIndicatorTypes", set);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getIndicatorTypes", throwable);
            throw throwable;
        }
        return set;
    }

    private Set<String> __getIndicatorTypes() {
        return this.__getcollectorservices().keySet();
    }

    public synchronized Set<String> getIndicatorCurrentUse(String string) throws JasmineProbeException {
        Set<String> set;
        if (!this.__MgetIndicatorCurrentUse$java_lang_String) {
            return this.__getIndicatorCurrentUse(string);
        }
        try {
            this.__IM.onEntry((Object)this, "getIndicatorCurrentUse$java_lang_String", new Object[]{string});
            set = this.__getIndicatorCurrentUse(string);
            this.__IM.onExit((Object)this, "getIndicatorCurrentUse$java_lang_String", set);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getIndicatorCurrentUse$java_lang_String", throwable);
            throw throwable;
        }
        return set;
    }

    private Set<String> __getIndicatorCurrentUse(String name) throws JasmineProbeException {
        HashSet<String> ret = new HashSet<String>();
        for (JasmineProbe probe : this.__getprobes().values()) {
            for (String indic : this.getRecursiveIndicatorList(probe)) {
                if (!indic.equals(name)) continue;
                ret.add(probe.getId());
            }
        }
        return ret;
    }

    public synchronized String createTarget(JasmineTarget jasmineTarget) throws JasmineProbeException {
        String string;
        if (!this.__McreateTarget$org_ow2_jasmine_probe_JasmineTarget) {
            return this.__createTarget(jasmineTarget);
        }
        try {
            this.__IM.onEntry((Object)this, "createTarget$org_ow2_jasmine_probe_JasmineTarget", new Object[]{jasmineTarget});
            string = this.__createTarget(jasmineTarget);
            this.__IM.onExit((Object)this, "createTarget$org_ow2_jasmine_probe_JasmineTarget", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "createTarget$org_ow2_jasmine_probe_JasmineTarget", throwable);
            throw throwable;
        }
        return string;
    }

    private String __createTarget(JasmineTarget newtarget) throws JasmineProbeException {
        String id = newtarget.getName();
        if (id == null || id.length() == 0) {
            throw new JasmineProbeException("No valid target name");
        }
        logger.debug((Object)("Create Target " + id), new Object[0]);
        JasmineTarget target = (JasmineTarget)this.__gettargets().get(id);
        if (target != null) {
            logger.debug((Object)("target already known: " + id), new Object[0]);
            if (target.equals(newtarget)) {
                return id;
            }
            if (this.isTargetUsed(target)) {
                logger.warn((Object)("oldtarget:" + target), new Object[0]);
                logger.warn((Object)("newtarget:" + newtarget), new Object[0]);
                throw new JasmineProbeException(id + "Target already known with another definition");
            }
            this.__gettargets().remove(id);
        }
        this.__gettargets().put(id, newtarget);
        return id;
    }

    public void changeTarget(JasmineTarget jasmineTarget) throws JasmineProbeException {
        if (!this.__MchangeTarget$org_ow2_jasmine_probe_JasmineTarget) {
            this.__changeTarget(jasmineTarget);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "changeTarget$org_ow2_jasmine_probe_JasmineTarget", new Object[]{jasmineTarget});
            this.__changeTarget(jasmineTarget);
            this.__IM.onExit((Object)this, "changeTarget$org_ow2_jasmine_probe_JasmineTarget", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "changeTarget$org_ow2_jasmine_probe_JasmineTarget", throwable);
            throw throwable;
        }
    }

    private void __changeTarget(JasmineTarget newtarget) throws JasmineProbeException {
        throw new JasmineProbeException("changeTarget not implemented");
    }

    public void removeTarget(String string) throws JasmineProbeException {
        if (!this.__MremoveTarget$java_lang_String) {
            this.__removeTarget(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "removeTarget$java_lang_String", new Object[]{string});
            this.__removeTarget(string);
            this.__IM.onExit((Object)this, "removeTarget$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "removeTarget$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __removeTarget(String name) throws JasmineProbeException {
        logger.debug((Object)"", new Object[0]);
        JasmineTarget target = (JasmineTarget)this.__gettargets().get(name);
        if (target == null) {
            throw new JasmineProbeException("This target does not exist: " + name);
        }
        if (this.isTargetUsed(target)) {
            throw new JasmineProbeException("This target is used and cannot be removed: " + name);
        }
        this.__gettargets().remove(name);
    }

    public synchronized String[] listTargets() {
        String[] stringArray;
        if (!this.__MlistTargets) {
            return this.__listTargets();
        }
        try {
            this.__IM.onEntry((Object)this, "listTargets", new Object[0]);
            stringArray = this.__listTargets();
            this.__IM.onExit((Object)this, "listTargets", (Object)stringArray);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "listTargets", throwable);
            throw throwable;
        }
        return stringArray;
    }

    private String[] __listTargets() {
        logger.debug((Object)"", new Object[0]);
        ArrayList<String> ret = new ArrayList<String>();
        for (JasmineTarget target : this.__gettargets().values()) {
            ret.add(target.getName());
        }
        return ret.toArray(new String[0]);
    }

    public synchronized List<JasmineTarget> getTargets() {
        List<JasmineTarget> list;
        if (!this.__MgetTargets) {
            return this.__getTargets();
        }
        try {
            this.__IM.onEntry((Object)this, "getTargets", new Object[0]);
            list = this.__getTargets();
            this.__IM.onExit((Object)this, "getTargets", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getTargets", throwable);
            throw throwable;
        }
        return list;
    }

    private List<JasmineTarget> __getTargets() {
        logger.debug((Object)"", new Object[0]);
        ArrayList<JasmineTarget> ret = new ArrayList<JasmineTarget>();
        ret.addAll(this.__gettargets().values());
        return ret;
    }

    public JasmineTarget getTarget(String string) {
        JasmineTarget jasmineTarget;
        if (!this.__MgetTarget$java_lang_String) {
            return this.__getTarget(string);
        }
        try {
            this.__IM.onEntry((Object)this, "getTarget$java_lang_String", new Object[]{string});
            jasmineTarget = this.__getTarget(string);
            this.__IM.onExit((Object)this, "getTarget$java_lang_String", (Object)jasmineTarget);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getTarget$java_lang_String", throwable);
            throw throwable;
        }
        return jasmineTarget;
    }

    private JasmineTarget __getTarget(String name) {
        JasmineTarget target = (JasmineTarget)this.__gettargets().get(name);
        return target;
    }

    public synchronized void addProbeListener(JasmineProbeListener jasmineProbeListener) {
        if (!this.__MaddProbeListener$org_ow2_jasmine_probe_JasmineProbeListener) {
            this.__addProbeListener(jasmineProbeListener);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "addProbeListener$org_ow2_jasmine_probe_JasmineProbeListener", new Object[]{jasmineProbeListener});
            this.__addProbeListener(jasmineProbeListener);
            this.__IM.onExit((Object)this, "addProbeListener$org_ow2_jasmine_probe_JasmineProbeListener", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "addProbeListener$org_ow2_jasmine_probe_JasmineProbeListener", throwable);
            throw throwable;
        }
    }

    private void __addProbeListener(JasmineProbeListener listener) {
        logger.debug((Object)"", new Object[0]);
        this.__getprobeListeners().add(listener);
    }

    public void saveConfig(String string) throws JasmineProbeException {
        if (!this.__MsaveConfig$java_lang_String) {
            this.__saveConfig(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "saveConfig$java_lang_String", new Object[]{string});
            this.__saveConfig(string);
            this.__IM.onExit((Object)this, "saveConfig$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "saveConfig$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __saveConfig(String path) throws JasmineProbeException {
        logger.debug((Object)"saveConfig", new Object[0]);
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(new File(JProp.getConfDir(), "probe-config.xml"));
        }
        catch (FileNotFoundException e) {
            throw new JasmineProbeException("Cannot write the config file 'probe-config.xml'" + e);
        }
        if (outputStream == null) {
            throw new JasmineProbeException("Cannot write the config file 'probe-config.xml'");
        }
        try {
            this.saveConfigFile(outputStream);
        }
        catch (Exception e) {
            logger.warn((Object)("could not save config: " + e), new Object[0]);
            throw new JasmineProbeException("could not save config: " + e.getMessage());
        }
    }

    public void loadConfig(String string) throws JasmineProbeException {
        if (!this.__MloadConfig$java_lang_String) {
            this.__loadConfig(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "loadConfig$java_lang_String", new Object[]{string});
            this.__loadConfig(string);
            this.__IM.onExit((Object)this, "loadConfig$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "loadConfig$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __loadConfig(String path) throws JasmineProbeException {
        logger.debug((Object)("loadConfig: " + path), new Object[0]);
        try {
            this.loadConfigFile(new FileInputStream(path));
        }
        catch (Exception e) {
            logger.warn((Object)("could not load config: " + e), new Object[0]);
            throw new JasmineProbeException("could not load config: " + e.getMessage());
        }
    }

    public synchronized JasmineCollector getCollector(String string, int n, String string2) throws JasmineProbeException {
        JasmineCollector jasmineCollector;
        if (!this.__MgetCollector$java_lang_String$int$java_lang_String) {
            return this.__getCollector(string, n, string2);
        }
        try {
            this.__IM.onEntry((Object)this, "getCollector$java_lang_String$int$java_lang_String", new Object[]{string, new Integer(n), string2});
            jasmineCollector = this.__getCollector(string, n, string2);
            this.__IM.onExit((Object)this, "getCollector$java_lang_String$int$java_lang_String", (Object)jasmineCollector);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getCollector$java_lang_String$int$java_lang_String", throwable);
            throw throwable;
        }
        return jasmineCollector;
    }

    private JasmineCollector __getCollector(String indicatorName, int period, String probeid) throws JasmineProbeException {
        JasmineIndicator indicator = (JasmineIndicator)this.__getindicators().get(indicatorName);
        if (indicator == null) {
            throw new JasmineProbeException("Cannot return collector for unexistent indicator " + indicatorName);
        }
        JasmineCollectorService jcs = (JasmineCollectorService)this.__getcollectorservices().get(indicator.getType());
        if (jcs == null) {
            logger.error((Object)"No CollectorService found for {0} having type {1}", new Object[]{indicatorName, indicator.getType()});
            throw new JasmineProbeException("No CollectorService found for " + indicatorName);
        }
        JasmineCollector collector = null;
        try {
            collector = jcs.getCollector(indicator, period, probeid);
        }
        catch (JasmineCollectorException e) {
            logger.error((Object)("Could not get the Collector for " + indicatorName + ": " + (Object)((Object)e)), new Object[0]);
            throw new JasmineProbeException("Could not get the Collector for " + indicatorName);
        }
        return collector;
    }

    public synchronized List<String> getAggregateFuntions() {
        List<String> list;
        if (!this.__MgetAggregateFuntions) {
            return this.__getAggregateFuntions();
        }
        try {
            this.__IM.onEntry((Object)this, "getAggregateFuntions", new Object[0]);
            list = this.__getAggregateFuntions();
            this.__IM.onExit((Object)this, "getAggregateFuntions", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getAggregateFuntions", throwable);
            throw throwable;
        }
        return list;
    }

    private List<String> __getAggregateFuntions() {
        if (!this.__getaggregateservices().isEmpty()) {
            ArrayList<String> functions = new ArrayList<String>();
            Set keySet = this.__getaggregateservices().keySet();
            for (String function : keySet) {
                functions.add(function);
            }
            return functions;
        }
        return null;
    }

    public synchronized JasmineAggregateService getAggregate(String string) {
        JasmineAggregateService jasmineAggregateService;
        if (!this.__MgetAggregate$java_lang_String) {
            return this.__getAggregate(string);
        }
        try {
            this.__IM.onEntry((Object)this, "getAggregate$java_lang_String", new Object[]{string});
            jasmineAggregateService = this.__getAggregate(string);
            this.__IM.onExit((Object)this, "getAggregate$java_lang_String", (Object)jasmineAggregateService);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getAggregate$java_lang_String", throwable);
            throw throwable;
        }
        return jasmineAggregateService;
    }

    private JasmineAggregateService __getAggregate(String key) {
        if (this.__getaggregateservices().containsKey(key)) {
            return (JasmineAggregateService)this.__getaggregateservices().get(key);
        }
        return null;
    }

    private synchronized String createOutputInternal(JasmineOutput jasmineOutput, boolean bl) throws JasmineProbeException {
        String string;
        if (!this.__McreateOutputInternal$org_ow2_jasmine_probe_JasmineOutput$boolean) {
            return this.__createOutputInternal(jasmineOutput, bl);
        }
        try {
            this.__IM.onEntry((Object)this, "createOutputInternal$org_ow2_jasmine_probe_JasmineOutput$boolean", new Object[]{jasmineOutput, new Boolean(bl)});
            string = this.__createOutputInternal(jasmineOutput, bl);
            this.__IM.onExit((Object)this, "createOutputInternal$org_ow2_jasmine_probe_JasmineOutput$boolean", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "createOutputInternal$org_ow2_jasmine_probe_JasmineOutput$boolean", throwable);
            throw throwable;
        }
        return string;
    }

    private String __createOutputInternal(JasmineOutput newoutput, boolean check) throws JasmineProbeException {
        String id = newoutput.getName();
        if (id == null || id.length() == 0) {
            throw new JasmineProbeException("No valid output name");
        }
        String type = newoutput.getType();
        if (type == null) {
            throw new JasmineProbeException("No type provided");
        }
        if (check) {
            JasmineOuterService jos = (JasmineOuterService)this.__getouterservices().get(type);
            if (jos == null) {
                throw new TypeNotSupportedException("Output type not supported: " + type);
            }
            String missinglist = "";
            for (JasminePropertyInfo jpi : jos.getPropertiesInfo()) {
                if (!jpi.isRequired()) continue;
                boolean found = false;
                for (String key : newoutput.getProperties().keySet()) {
                    if (!key.equals(jpi.getName())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                missinglist = missinglist + " " + jpi.getName();
            }
            if (missinglist.length() > 0) {
                throw new PropertyMissingException("Missing mandatory properties:" + missinglist);
            }
        }
        logger.debug((Object)("Create Output " + id), new Object[0]);
        JasmineOutput output = (JasmineOutput)this.__getoutputs().get(id);
        if (output != null) {
            logger.debug((Object)("output already known: " + id), new Object[0]);
            if (output.equals((Object)newoutput)) {
                return id;
            }
            if (this.isOutputUsed(output, true)) {
                logger.warn((Object)("oldoutput:" + output), new Object[0]);
                logger.warn((Object)("newoutput:" + newoutput), new Object[0]);
                throw new JasmineProbeException(id + " output already known with another definition");
            }
            this.__getoutputs().remove(id);
        }
        this.__getoutputs().put(id, newoutput);
        return id;
    }

    public synchronized String createIndicatorInternal(JasmineIndicator jasmineIndicator, boolean bl) throws JasmineProbeException {
        String string;
        if (!this.__McreateIndicatorInternal$org_ow2_jasmine_probe_JasmineIndicator$boolean) {
            return this.__createIndicatorInternal(jasmineIndicator, bl);
        }
        try {
            this.__IM.onEntry((Object)this, "createIndicatorInternal$org_ow2_jasmine_probe_JasmineIndicator$boolean", new Object[]{jasmineIndicator, new Boolean(bl)});
            string = this.__createIndicatorInternal(jasmineIndicator, bl);
            this.__IM.onExit((Object)this, "createIndicatorInternal$org_ow2_jasmine_probe_JasmineIndicator$boolean", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "createIndicatorInternal$org_ow2_jasmine_probe_JasmineIndicator$boolean", throwable);
            throw throwable;
        }
        return string;
    }

    private String __createIndicatorInternal(JasmineIndicator newindic, boolean check) throws JasmineProbeException {
        String id = newindic.getName();
        if (id == null || id.length() == 0) {
            throw new JasmineProbeException("Automatic indicator name is not supported yet");
        }
        String type = newindic.getType();
        if (type == null) {
            throw new TypeNotSupportedException("No type provided");
        }
        if (check) {
            JasmineCollectorService jcs = (JasmineCollectorService)this.__getcollectorservices().get(type);
            if (jcs == null) {
                throw new TypeNotSupportedException("Indicator type not supported: " + type);
            }
            String missinglist = "";
            for (JasminePropertyInfo jpi : jcs.getPropertiesInfo()) {
                if (!jpi.isRequired()) continue;
                boolean found = false;
                for (String key : newindic.getProperties().keySet()) {
                    if (!key.equals(jpi.getName())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                missinglist = missinglist + " " + jpi.getName();
            }
            if (missinglist.length() > 0) {
                throw new PropertyMissingException("Missing mandatory properties:" + missinglist);
            }
        }
        logger.debug((Object)("Create Indicator " + id), new Object[0]);
        JasmineIndicator indic = (JasmineIndicator)this.__getindicators().get(id);
        if (indic != null) {
            logger.debug((Object)("indicator already known: " + id), new Object[0]);
            if (indic.equals(newindic)) {
                return id;
            }
            if (this.isIndicatorUsed(indic, true)) {
                logger.warn((Object)("old indic:" + indic), new Object[0]);
                logger.warn((Object)("new indic:" + newindic), new Object[0]);
                throw new JasmineProbeException(id + "Indicator already known with another definition");
            }
            this.__getindicators().remove(id);
        }
        this.__getindicators().put(id, newindic);
        return id;
    }

    private synchronized String getNewProbeId() {
        String string;
        if (!this.__MgetNewProbeId) {
            return this.__getNewProbeId();
        }
        try {
            this.__IM.onEntry((Object)this, "getNewProbeId", new Object[0]);
            string = this.__getNewProbeId();
            this.__IM.onExit((Object)this, "getNewProbeId", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getNewProbeId", throwable);
            throw throwable;
        }
        return string;
    }

    private String __getNewProbeId() {
        String ret = "probe-0";
        boolean found = false;
        block0: while (!found) {
            StringBuilder stringBuilder = new StringBuilder().append("probe-");
            JProbeManager jProbeManager = this;
            int n = jProbeManager.__getprobeCount() + 1;
            jProbeManager.__setprobeCount(n);
            ret = stringBuilder.append(n).toString();
            found = true;
            for (JasmineProbe p : this.__getprobes().values()) {
                if (!p.getId().equals(ret)) continue;
                found = false;
                continue block0;
            }
        }
        return ret;
    }

    private void readConfig() throws Exception {
        if (!this.__MreadConfig) {
            this.__readConfig();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "readConfig", new Object[0]);
            this.__readConfig();
            this.__IM.onExit((Object)this, "readConfig", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "readConfig", throwable);
            throw throwable;
        }
    }

    private void __readConfig() throws Exception {
        String configurationFile = "probe-config.xml";
        ClassLoader loader = ClassLoader.getSystemClassLoader();
        InputStream resource = null;
        try {
            resource = loader.getResourceAsStream(configurationFile);
        }
        catch (Exception e) {
            logger.error((Object)("Cannot find probe-config.xml: " + e), new Object[0]);
            throw e;
        }
        if (resource == null) {
            logger.error((Object)"Cannot find probe-config.xml", new Object[0]);
            return;
        }
        logger.debug((Object)"Parsing probe-config.xml", new Object[0]);
        this.loadConfigFile(resource);
    }

    private void saveConfigFile(OutputStream outputStream) throws Exception {
        if (!this.__MsaveConfigFile$java_io_OutputStream) {
            this.__saveConfigFile(outputStream);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "saveConfigFile$java_io_OutputStream", new Object[]{outputStream});
            this.__saveConfigFile(outputStream);
            this.__IM.onExit((Object)this, "saveConfigFile$java_io_OutputStream", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "saveConfigFile$java_io_OutputStream", throwable);
            throw throwable;
        }
    }

    private void __saveConfigFile(OutputStream resource) throws Exception {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            this.__setprobeConfig(new ProbeConfig());
            ArrayList<Output> olist = new ArrayList<Output>();
            for (JasmineOutput jo : this.__getoutputs().values()) {
                Output output = new Output();
                output.setId(jo.getName());
                output.setType(OutputType.fromValue(jo.getType()));
                for (String key : jo.getProperties().keySet()) {
                    Paramvalue pv = new Paramvalue();
                    pv.setName(key);
                    pv.setValue((String)jo.getProperties().get(key));
                    output.getParam().add(pv);
                }
                olist.add(output);
            }
            this.__getprobeConfig().setOutput(olist);
            ArrayList<Target> tlist = new ArrayList<Target>();
            for (JasmineTarget jt : this.__gettargets().values()) {
                Target target = new Target();
                target.setId(jt.getName());
                target.setUrl(jt.getUrl());
                tlist.add(target);
            }
            this.__getprobeConfig().setTarget(tlist);
            ArrayList<Indicator> ilist = new ArrayList<Indicator>();
            for (JasmineIndicator ji : this.__getindicators().values()) {
                Indicator indic = new Indicator();
                indic.setId(ji.getName());
                indic.setType(IndicatorType.fromValue(ji.getType()));
                String scale = new Long(ji.getScale()).toString();
                indic.setScale(new BigInteger(scale));
                for (String key : ji.getProperties().keySet()) {
                    Paramvalue pv = new Paramvalue();
                    pv.setName(key);
                    pv.setValue((String)ji.getProperties().get(key));
                    indic.getParam().add(pv);
                }
                ilist.add(indic);
            }
            this.__getprobeConfig().setIndicator(ilist);
            ArrayList<Probe> plist = new ArrayList<Probe>();
            for (JasmineProbe jp : this.__getprobes().values()) {
                Probe pdata = new Probe();
                String period = new Long(jp.getPeriod()).toString();
                pdata.setPeriod(new BigInteger(period));
                ArrayList<String> onlist = new ArrayList<String>();
                for (String output : jp.getOutputList()) {
                    onlist.add(output);
                }
                pdata.setOutput(onlist);
                ArrayList<String> inlist = new ArrayList<String>();
                for (String ind : jp.getIndicatorList()) {
                    inlist.add(ind);
                }
                pdata.setIndicator(inlist);
                switch (jp.getStatus()) {
                    case 0: 
                    case 3: {
                        pdata.setStatus(StatusType.STOPPED);
                        break;
                    }
                    case 1: 
                    case 2: {
                        pdata.setStatus(StatusType.STARTED);
                    }
                }
                plist.add(pdata);
            }
            this.__getprobeConfig().setProbe(plist);
            marshaller.marshal((Object)this.__getprobeConfig(), resource);
        }
        catch (Exception e) {
            logger.error((Object)("Error while writing probe-config.xml: " + e), new Object[0]);
            throw new JasmineProbeException("Error while writing probe-config.xml: " + e);
        }
        finally {
            try {
                resource.close();
            }
            catch (IOException ignore) {}
        }
    }

    private synchronized void loadConfigFile(InputStream inputStream) throws JasmineProbeException {
        if (!this.__MloadConfigFile$java_io_InputStream) {
            this.__loadConfigFile(inputStream);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "loadConfigFile$java_io_InputStream", new Object[]{inputStream});
            this.__loadConfigFile(inputStream);
            this.__IM.onExit((Object)this, "loadConfigFile$java_io_InputStream", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "loadConfigFile$java_io_InputStream", throwable);
            throw throwable;
        }
    }

    private void __loadConfigFile(InputStream resource) throws JasmineProbeException {
        try {
            HashMap<String, String> props;
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            this.__setprobeConfig((ProbeConfig)unmarshaller.unmarshal(resource));
            for (Output output : this.__getprobeConfig().getOutput()) {
                JasmineOutput jo = new JasmineOutput();
                jo.setName(output.getId());
                jo.setType(output.getType().value());
                props = new HashMap<String, String>();
                for (Paramvalue param : output.getParam()) {
                    props.put(param.getName(), param.getValue());
                }
                jo.setProperties(props);
                this.createOutputInternal(jo, false);
            }
            for (Target target : this.__getprobeConfig().getTarget()) {
                JasmineTarget jt = new JasmineTarget();
                jt.setName(target.getId());
                jt.setUrl(target.getUrl());
                props = new HashMap();
                for (Paramvalue param : target.getParam()) {
                    props.put(param.getName(), param.getValue());
                }
                jt.setProperties(props);
                this.createTarget(jt);
            }
            for (Indicator indic : this.__getprobeConfig().getIndicator()) {
                JasmineIndicator ji = new JasmineIndicator();
                ji.setName(indic.getId());
                ji.setType(indic.getType().value());
                ji.setScale(indic.getScale().intValue());
                props = new HashMap();
                for (Paramvalue param : indic.getParam()) {
                    props.put(param.getName(), param.getValue());
                }
                ji.setProperties(props);
                this.createIndicatorInternal(ji, false);
            }
            for (Probe probe : this.__getprobeConfig().getProbe()) {
                JasmineProbe jp = new JasmineProbe();
                jp.setId(probe.getId());
                jp.setPeriod(probe.getPeriod().intValue());
                jp.setOutputList(probe.getOutput());
                jp.setIndicatorList(probe.getIndicator());
                if (probe.getStatus() != null && probe.getStatus().value().equals("started")) {
                    jp.setStatus(4);
                }
                this.createProbe(jp);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Error in probe-config.xml: " + e), new Object[0]);
            throw new JasmineProbeException("Error in probe-config.xml: " + e);
        }
        finally {
            try {
                resource.close();
            }
            catch (IOException ignore) {}
        }
    }

    private synchronized boolean isOutputUsed(JasmineOutput jasmineOutput, boolean bl) {
        boolean bl2;
        if (!this.__MisOutputUsed$org_ow2_jasmine_probe_JasmineOutput$boolean) {
            return this.__isOutputUsed(jasmineOutput, bl);
        }
        try {
            this.__IM.onEntry((Object)this, "isOutputUsed$org_ow2_jasmine_probe_JasmineOutput$boolean", new Object[]{jasmineOutput, new Boolean(bl)});
            bl2 = this.__isOutputUsed(jasmineOutput, bl);
            this.__IM.onExit((Object)this, "isOutputUsed$org_ow2_jasmine_probe_JasmineOutput$boolean", (Object)new Boolean(bl2));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "isOutputUsed$org_ow2_jasmine_probe_JasmineOutput$boolean", throwable);
            throw throwable;
        }
        return bl2;
    }

    private boolean __isOutputUsed(JasmineOutput output, boolean checkrun) {
        for (JasmineProbe probe : this.__getprobes().values()) {
            for (String name : probe.getOutputList()) {
                if (!name.equals(output.getName()) || checkrun && probe.getStatus() == 0) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isTargetUsed(JasmineTarget jasmineTarget) {
        boolean bl;
        if (!this.__MisTargetUsed$org_ow2_jasmine_probe_JasmineTarget) {
            return this.__isTargetUsed(jasmineTarget);
        }
        try {
            this.__IM.onEntry((Object)this, "isTargetUsed$org_ow2_jasmine_probe_JasmineTarget", new Object[]{jasmineTarget});
            bl = this.__isTargetUsed(jasmineTarget);
            this.__IM.onExit((Object)this, "isTargetUsed$org_ow2_jasmine_probe_JasmineTarget", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "isTargetUsed$org_ow2_jasmine_probe_JasmineTarget", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __isTargetUsed(JasmineTarget target) {
        for (JasmineProbe probe : this.__getprobes().values()) {
            if (!probe.getTargetList().contains(target)) continue;
            return true;
        }
        return false;
    }

    private synchronized boolean isIndicatorUsed(JasmineIndicator jasmineIndicator, boolean bl) {
        boolean bl2;
        if (!this.__MisIndicatorUsed$org_ow2_jasmine_probe_JasmineIndicator$boolean) {
            return this.__isIndicatorUsed(jasmineIndicator, bl);
        }
        try {
            this.__IM.onEntry((Object)this, "isIndicatorUsed$org_ow2_jasmine_probe_JasmineIndicator$boolean", new Object[]{jasmineIndicator, new Boolean(bl)});
            bl2 = this.__isIndicatorUsed(jasmineIndicator, bl);
            this.__IM.onExit((Object)this, "isIndicatorUsed$org_ow2_jasmine_probe_JasmineIndicator$boolean", (Object)new Boolean(bl2));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "isIndicatorUsed$org_ow2_jasmine_probe_JasmineIndicator$boolean", throwable);
            throw throwable;
        }
        return bl2;
    }

    private boolean __isIndicatorUsed(JasmineIndicator indicator, boolean checkrun) {
        for (JasmineProbe probe : this.__getprobes().values()) {
            for (String indic : this.getRecursiveIndicatorList(probe)) {
                if (!indic.equals(indicator.getName()) || checkrun && probe.getStatus() == 0) continue;
                return true;
            }
        }
        return false;
    }

    public synchronized void setProbeState(JProbe jProbe, int n, String string) {
        if (!this.__MsetProbeState$org_ow2_jasmine_probe_manager_JProbe$int$java_lang_String) {
            this.__setProbeState(jProbe, n, string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setProbeState$org_ow2_jasmine_probe_manager_JProbe$int$java_lang_String", new Object[]{jProbe, new Integer(n), string});
            this.__setProbeState(jProbe, n, string);
            this.__IM.onExit((Object)this, "setProbeState$org_ow2_jasmine_probe_manager_JProbe$int$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setProbeState$org_ow2_jasmine_probe_manager_JProbe$int$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __setProbeState(JProbe running, int state, String message) {
        logger.debug((Object)("state =" + state), new Object[0]);
        running.setStatus(state);
        running.setError(message);
        for (JasmineProbeListener listener : this.__getprobeListeners()) {
            listener.notifyEvent(running.getProbeDef());
        }
    }

    private synchronized void startWaitingProbes() {
        if (!this.__MstartWaitingProbes) {
            this.__startWaitingProbes();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "startWaitingProbes", new Object[0]);
            this.__startWaitingProbes();
            this.__IM.onExit((Object)this, "startWaitingProbes", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "startWaitingProbes", throwable);
            throw throwable;
        }
    }

    private void __startWaitingProbes() {
        for (JasmineProbe probe : this.__getprobes().values()) {
            if (probe.getStatus() != 4) continue;
            logger.debug((Object)(probe.getId() + " trying to start"), new Object[0]);
            JProbe running = new JProbe(probe, this);
            try {
                running.resume();
            }
            catch (JasmineProbeException e) {
                logger.warn((Object)("Cannot start probe now: " + probe.getId()), new Object[0]);
                continue;
            }
            this.__getrunnings().put(probe.getId(), running);
        }
    }

    private synchronized List<String> getRecursiveIndicatorList(JasmineProbe jasmineProbe) {
        List<String> list;
        if (!this.__MgetRecursiveIndicatorList$org_ow2_jasmine_probe_JasmineProbe) {
            return this.__getRecursiveIndicatorList(jasmineProbe);
        }
        try {
            this.__IM.onEntry((Object)this, "getRecursiveIndicatorList$org_ow2_jasmine_probe_JasmineProbe", new Object[]{jasmineProbe});
            list = this.__getRecursiveIndicatorList(jasmineProbe);
            this.__IM.onExit((Object)this, "getRecursiveIndicatorList$org_ow2_jasmine_probe_JasmineProbe", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getRecursiveIndicatorList$org_ow2_jasmine_probe_JasmineProbe", throwable);
            throw throwable;
        }
        return list;
    }

    private List<String> __getRecursiveIndicatorList(JasmineProbe probe) {
        ArrayList<String> ret = new ArrayList<String>();
        for (String iname : probe.getIndicatorList()) {
            ret.add(iname);
            JasmineIndicator indic = (JasmineIndicator)this.__getindicators().get(iname);
            JasmineCollectorService jcs = (JasmineCollectorService)this.__getcollectorservices().get(indic.getType());
            if (jcs == null) continue;
            List full = jcs.getDependantIndicators(indic);
            ret.addAll(full);
        }
        return ret;
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("probeListeners")) {
                this.__FprobeListeners = true;
            }
            if (set.contains("jasmineProbeScheduler")) {
                this.__FjasmineProbeScheduler = true;
            }
            if (set.contains("collectorservices")) {
                this.__Fcollectorservices = true;
            }
            if (set.contains("mbeanObjectName")) {
                this.__FmbeanObjectName = true;
            }
            if (set.contains("jmxService")) {
                this.__FjmxService = true;
            }
            if (set.contains("indicators")) {
                this.__Findicators = true;
            }
            if (set.contains("probes")) {
                this.__Fprobes = true;
            }
            if (set.contains("probeCount")) {
                this.__FprobeCount = true;
            }
            if (set.contains("outerservices")) {
                this.__Fouterservices = true;
            }
            if (set.contains("aggregateservices")) {
                this.__Faggregateservices = true;
            }
            if (set.contains("outputs")) {
                this.__Foutputs = true;
            }
            if (set.contains("targets")) {
                this.__Ftargets = true;
            }
            if (set.contains("probeConfig")) {
                this.__FprobeConfig = true;
            }
            if (set.contains("runnings")) {
                this.__Frunnings = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
            if (set.contains("bindOuterService$org_ow2_jasmine_probe_outer_JasmineOuterService$org_osgi_framework_ServiceReference")) {
                this.__MbindOuterService$org_ow2_jasmine_probe_outer_JasmineOuterService$org_osgi_framework_ServiceReference = true;
            }
            if (set.contains("unbindOuterService$org_ow2_jasmine_probe_outer_JasmineOuterService$org_osgi_framework_ServiceReference")) {
                this.__MunbindOuterService$org_ow2_jasmine_probe_outer_JasmineOuterService$org_osgi_framework_ServiceReference = true;
            }
            if (set.contains("bindCollectorService$org_ow2_jasmine_probe_collector_JasmineCollectorService$org_osgi_framework_ServiceReference")) {
                this.__MbindCollectorService$org_ow2_jasmine_probe_collector_JasmineCollectorService$org_osgi_framework_ServiceReference = true;
            }
            if (set.contains("unbindCollectorService$org_ow2_jasmine_probe_collector_JasmineCollectorService$org_osgi_framework_ServiceReference")) {
                this.__MunbindCollectorService$org_ow2_jasmine_probe_collector_JasmineCollectorService$org_osgi_framework_ServiceReference = true;
            }
            if (set.contains("bindAggregateService$org_ow2_jasmine_probe_collector_JasmineAggregateService$org_osgi_framework_ServiceReference")) {
                this.__MbindAggregateService$org_ow2_jasmine_probe_collector_JasmineAggregateService$org_osgi_framework_ServiceReference = true;
            }
            if (set.contains("unbindAggregateService$org_ow2_jasmine_probe_collector_JasmineAggregateService$org_osgi_framework_ServiceReference")) {
                this.__MunbindAggregateService$org_ow2_jasmine_probe_collector_JasmineAggregateService$org_osgi_framework_ServiceReference = true;
            }
            if (set.contains("getScheduler")) {
                this.__MgetScheduler = true;
            }
            if (set.contains("getOuterService$java_lang_String")) {
                this.__MgetOuterService$java_lang_String = true;
            }
            if (set.contains("getCollectorService$java_lang_String")) {
                this.__MgetCollectorService$java_lang_String = true;
            }
            if (set.contains("createProbe$org_ow2_jasmine_probe_JasmineProbe")) {
                this.__McreateProbe$org_ow2_jasmine_probe_JasmineProbe = true;
            }
            if (set.contains("removeProbe$java_lang_String")) {
                this.__MremoveProbe$java_lang_String = true;
            }
            if (set.contains("removeAllProbes")) {
                this.__MremoveAllProbes = true;
            }
            if (set.contains("getProbes")) {
                this.__MgetProbes = true;
            }
            if (set.contains("listProbes")) {
                this.__MlistProbes = true;
            }
            if (set.contains("getProbe$java_lang_String")) {
                this.__MgetProbe$java_lang_String = true;
            }
            if (set.contains("startProbe$java_lang_String")) {
                this.__MstartProbe$java_lang_String = true;
            }
            if (set.contains("stopProbe$java_lang_String")) {
                this.__MstopProbe$java_lang_String = true;
            }
            if (set.contains("startAllProbes")) {
                this.__MstartAllProbes = true;
            }
            if (set.contains("stopAllProbes")) {
                this.__MstopAllProbes = true;
            }
            if (set.contains("changeProbe$org_ow2_jasmine_probe_JasmineProbe")) {
                this.__MchangeProbe$org_ow2_jasmine_probe_JasmineProbe = true;
            }
            if (set.contains("createOutput$org_ow2_jasmine_probe_JasmineOutput")) {
                this.__McreateOutput$org_ow2_jasmine_probe_JasmineOutput = true;
            }
            if (set.contains("changeOutput$org_ow2_jasmine_probe_JasmineOutput")) {
                this.__MchangeOutput$org_ow2_jasmine_probe_JasmineOutput = true;
            }
            if (set.contains("removeOutput$java_lang_String")) {
                this.__MremoveOutput$java_lang_String = true;
            }
            if (set.contains("listOutputs")) {
                this.__MlistOutputs = true;
            }
            if (set.contains("getOutputs")) {
                this.__MgetOutputs = true;
            }
            if (set.contains("getOutput$java_lang_String")) {
                this.__MgetOutput$java_lang_String = true;
            }
            if (set.contains("getOutputPropertyInfos$java_lang_String")) {
                this.__MgetOutputPropertyInfos$java_lang_String = true;
            }
            if (set.contains("getOutputTypes")) {
                this.__MgetOutputTypes = true;
            }
            if (set.contains("getOutputCurrentUse$java_lang_String")) {
                this.__MgetOutputCurrentUse$java_lang_String = true;
            }
            if (set.contains("createIndicator$org_ow2_jasmine_probe_JasmineIndicator")) {
                this.__McreateIndicator$org_ow2_jasmine_probe_JasmineIndicator = true;
            }
            if (set.contains("changeIndicator$org_ow2_jasmine_probe_JasmineIndicator")) {
                this.__MchangeIndicator$org_ow2_jasmine_probe_JasmineIndicator = true;
            }
            if (set.contains("removeIndicator$java_lang_String")) {
                this.__MremoveIndicator$java_lang_String = true;
            }
            if (set.contains("getIndicator$java_lang_String")) {
                this.__MgetIndicator$java_lang_String = true;
            }
            if (set.contains("getIndicators")) {
                this.__MgetIndicators = true;
            }
            if (set.contains("listIndicators")) {
                this.__MlistIndicators = true;
            }
            if (set.contains("getIndicatorPropertyInfos$java_lang_String")) {
                this.__MgetIndicatorPropertyInfos$java_lang_String = true;
            }
            if (set.contains("getIndicatorTypes")) {
                this.__MgetIndicatorTypes = true;
            }
            if (set.contains("getIndicatorCurrentUse$java_lang_String")) {
                this.__MgetIndicatorCurrentUse$java_lang_String = true;
            }
            if (set.contains("createTarget$org_ow2_jasmine_probe_JasmineTarget")) {
                this.__McreateTarget$org_ow2_jasmine_probe_JasmineTarget = true;
            }
            if (set.contains("changeTarget$org_ow2_jasmine_probe_JasmineTarget")) {
                this.__MchangeTarget$org_ow2_jasmine_probe_JasmineTarget = true;
            }
            if (set.contains("removeTarget$java_lang_String")) {
                this.__MremoveTarget$java_lang_String = true;
            }
            if (set.contains("listTargets")) {
                this.__MlistTargets = true;
            }
            if (set.contains("getTargets")) {
                this.__MgetTargets = true;
            }
            if (set.contains("getTarget$java_lang_String")) {
                this.__MgetTarget$java_lang_String = true;
            }
            if (set.contains("addProbeListener$org_ow2_jasmine_probe_JasmineProbeListener")) {
                this.__MaddProbeListener$org_ow2_jasmine_probe_JasmineProbeListener = true;
            }
            if (set.contains("saveConfig$java_lang_String")) {
                this.__MsaveConfig$java_lang_String = true;
            }
            if (set.contains("loadConfig$java_lang_String")) {
                this.__MloadConfig$java_lang_String = true;
            }
            if (set.contains("getCollector$java_lang_String$int$java_lang_String")) {
                this.__MgetCollector$java_lang_String$int$java_lang_String = true;
            }
            if (set.contains("getAggregateFuntions")) {
                this.__MgetAggregateFuntions = true;
            }
            if (set.contains("getAggregate$java_lang_String")) {
                this.__MgetAggregate$java_lang_String = true;
            }
            if (set.contains("createOutputInternal$org_ow2_jasmine_probe_JasmineOutput$boolean")) {
                this.__McreateOutputInternal$org_ow2_jasmine_probe_JasmineOutput$boolean = true;
            }
            if (set.contains("createIndicatorInternal$org_ow2_jasmine_probe_JasmineIndicator$boolean")) {
                this.__McreateIndicatorInternal$org_ow2_jasmine_probe_JasmineIndicator$boolean = true;
            }
            if (set.contains("getNewProbeId")) {
                this.__MgetNewProbeId = true;
            }
            if (set.contains("readConfig")) {
                this.__MreadConfig = true;
            }
            if (set.contains("saveConfigFile$java_io_OutputStream")) {
                this.__MsaveConfigFile$java_io_OutputStream = true;
            }
            if (set.contains("loadConfigFile$java_io_InputStream")) {
                this.__MloadConfigFile$java_io_InputStream = true;
            }
            if (set.contains("isOutputUsed$org_ow2_jasmine_probe_JasmineOutput$boolean")) {
                this.__MisOutputUsed$org_ow2_jasmine_probe_JasmineOutput$boolean = true;
            }
            if (set.contains("isTargetUsed$org_ow2_jasmine_probe_JasmineTarget")) {
                this.__MisTargetUsed$org_ow2_jasmine_probe_JasmineTarget = true;
            }
            if (set.contains("isIndicatorUsed$org_ow2_jasmine_probe_JasmineIndicator$boolean")) {
                this.__MisIndicatorUsed$org_ow2_jasmine_probe_JasmineIndicator$boolean = true;
            }
            if (set.contains("setProbeState$org_ow2_jasmine_probe_manager_JProbe$int$java_lang_String")) {
                this.__MsetProbeState$org_ow2_jasmine_probe_manager_JProbe$int$java_lang_String = true;
            }
            if (set.contains("startWaitingProbes")) {
                this.__MstartWaitingProbes = true;
            }
            if (set.contains("getRecursiveIndicatorList$org_ow2_jasmine_probe_JasmineProbe")) {
                this.__MgetRecursiveIndicatorList$org_ow2_jasmine_probe_JasmineProbe = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

