/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.shell;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.shell.Command;
import org.ow2.jasmine.probe.JasmineIndicator;
import org.ow2.jasmine.probe.JasmineProbeManager;
import org.ow2.jasmine.probe.shell.IndicatorCreateCommandParams;
import org.ow2.jasmine.probe.shell.JasmineProbeCommand;

@Component(name="IndicatorCreateCommand")
@Provides
public class IndicatorCreateCommand
extends JasmineProbeCommand
implements Command,
Pojo {
    private InstanceManager __IM;
    private boolean __Fname;
    private String name;
    private boolean __FrequiredOptions;
    private String requiredOptions;
    private boolean __Fdescription;
    private String description;
    private boolean __FprobeManager;
    @Requires
    JasmineProbeManager probeManager;
    private boolean __MgetName;
    private boolean __MgetShortDescription;
    private boolean __MgetProperties;
    private boolean __MgetRequiredOptions;
    private boolean __MgetProbeManager;
    private boolean __Mexecute$java_lang_String$java_io_PrintStream$java_io_PrintStream;

    String __getname() {
        if (!this.__Fname) {
            return this.name;
        }
        return (String)this.__IM.onGet((Object)this, "name");
    }

    void __setname(String string) {
        if (!this.__Fname) {
            this.name = string;
            return;
        }
        this.__IM.onSet((Object)this, "name", (Object)string);
    }

    String __getrequiredOptions() {
        if (!this.__FrequiredOptions) {
            return this.requiredOptions;
        }
        return (String)this.__IM.onGet((Object)this, "requiredOptions");
    }

    void __setrequiredOptions(String string) {
        if (!this.__FrequiredOptions) {
            this.requiredOptions = string;
            return;
        }
        this.__IM.onSet((Object)this, "requiredOptions", (Object)string);
    }

    String __getdescription() {
        if (!this.__Fdescription) {
            return this.description;
        }
        return (String)this.__IM.onGet((Object)this, "description");
    }

    void __setdescription(String string) {
        if (!this.__Fdescription) {
            this.description = string;
            return;
        }
        this.__IM.onSet((Object)this, "description", (Object)string);
    }

    JasmineProbeManager __getprobeManager() {
        if (!this.__FprobeManager) {
            return this.probeManager;
        }
        return (JasmineProbeManager)this.__IM.onGet((Object)this, "probeManager");
    }

    void __setprobeManager(JasmineProbeManager jasmineProbeManager) {
        if (!this.__FprobeManager) {
            this.probeManager = jasmineProbeManager;
            return;
        }
        this.__IM.onSet((Object)this, "probeManager", (Object)jasmineProbeManager);
    }

    public IndicatorCreateCommand() {
        this(null);
    }

    private IndicatorCreateCommand(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setname("indicator-create");
        this.__setrequiredOptions("-n indicatorName -t indicatorType");
        this.__setdescription("Create an Indicator");
        this.__setprobeManager(null);
        this.setParams(new IndicatorCreateCommandParams());
    }

    public String getName() {
        String string;
        if (!this.__MgetName) {
            return this.__getName();
        }
        try {
            this.__IM.onEntry((Object)this, "getName", new Object[0]);
            string = this.__getName();
            this.__IM.onExit((Object)this, "getName", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getName", throwable);
            throw throwable;
        }
        return string;
    }

    private String __getName() {
        return this.__getname();
    }

    public String getShortDescription() {
        String string;
        if (!this.__MgetShortDescription) {
            return this.__getShortDescription();
        }
        try {
            this.__IM.onEntry((Object)this, "getShortDescription", new Object[0]);
            string = this.__getShortDescription();
            this.__IM.onExit((Object)this, "getShortDescription", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getShortDescription", throwable);
            throw throwable;
        }
        return string;
    }

    private String __getShortDescription() {
        return this.__getdescription();
    }

    public String getProperties() {
        String string;
        if (!this.__MgetProperties) {
            return this.__getProperties();
        }
        try {
            this.__IM.onEntry((Object)this, "getProperties", new Object[0]);
            string = this.__getProperties();
            this.__IM.onExit((Object)this, "getProperties", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getProperties", throwable);
            throw throwable;
        }
        return string;
    }

    private String __getProperties() {
        String props = new String("  Properties: ....");
        return props;
    }

    public String getRequiredOptions() {
        String string;
        if (!this.__MgetRequiredOptions) {
            return this.__getRequiredOptions();
        }
        try {
            this.__IM.onEntry((Object)this, "getRequiredOptions", new Object[0]);
            string = this.__getRequiredOptions();
            this.__IM.onExit((Object)this, "getRequiredOptions", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getRequiredOptions", throwable);
            throw throwable;
        }
        return string;
    }

    private String __getRequiredOptions() {
        return this.__getrequiredOptions();
    }

    public JasmineProbeManager getProbeManager() {
        JasmineProbeManager jasmineProbeManager;
        if (!this.__MgetProbeManager) {
            return this.__getProbeManager();
        }
        try {
            this.__IM.onEntry((Object)this, "getProbeManager", new Object[0]);
            jasmineProbeManager = this.__getProbeManager();
            this.__IM.onExit((Object)this, "getProbeManager", (Object)jasmineProbeManager);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getProbeManager", throwable);
            throw throwable;
        }
        return jasmineProbeManager;
    }

    private JasmineProbeManager __getProbeManager() {
        return this.__getprobeManager();
    }

    public void execute(String string, PrintStream printStream, PrintStream printStream2) {
        if (!this.__Mexecute$java_lang_String$java_io_PrintStream$java_io_PrintStream) {
            this.__execute(string, printStream, printStream2);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "execute$java_lang_String$java_io_PrintStream$java_io_PrintStream", new Object[]{string, printStream, printStream2});
            this.__execute(string, printStream, printStream2);
            this.__IM.onExit((Object)this, "execute$java_lang_String$java_io_PrintStream$java_io_PrintStream", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "execute$java_lang_String$java_io_PrintStream$java_io_PrintStream", throwable);
            throw throwable;
        }
    }

    private void __execute(String line, PrintStream out, PrintStream err) {
        boolean validOptions = this.parseOptions(line, out, err);
        if (!validOptions) {
            err.println(this.getUsage());
            return;
        }
        IndicatorCreateCommandParams params = (IndicatorCreateCommandParams)this.getParams();
        String indicatorName = params.getName();
        String indicatorType = params.getType();
        int indicatorScale = params.getScale();
        List<String> indicatorParams = params.getProps();
        HashMap<String, String> properties = new HashMap<String, String>();
        for (String indicatorParam : indicatorParams) {
            if (this.validParam(indicatorParam)) {
                int indexEqual = indicatorParam.indexOf("=");
                String indicatorParamName = indicatorParam.substring(0, indexEqual);
                String indicatorParamValue = indicatorParam.substring(indexEqual + 1, indicatorParam.length());
                properties.put(indicatorParamName, indicatorParamValue);
                continue;
            }
            err.println(this.__getname() + " " + indicatorName + " failed");
            err.println("Wrong properties format for " + indicatorParam);
            err.println("Expected format is paramName=paramValue");
            err.println(this.getUsage());
            params.reset();
            return;
        }
        params.reset();
        JasmineIndicator newIndicator = new JasmineIndicator();
        newIndicator.setName(indicatorName);
        newIndicator.setType(indicatorType);
        newIndicator.setScale(indicatorScale);
        newIndicator.setProperties(properties);
        this.createIndicator(this.__getname(), newIndicator, out, err);
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("probeManager")) {
                this.__FprobeManager = true;
            }
            if (set.contains("requiredOptions")) {
                this.__FrequiredOptions = true;
            }
            if (set.contains("description")) {
                this.__Fdescription = true;
            }
            if (set.contains("name")) {
                this.__Fname = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("getName")) {
                this.__MgetName = true;
            }
            if (set.contains("getShortDescription")) {
                this.__MgetShortDescription = true;
            }
            if (set.contains("getProperties")) {
                this.__MgetProperties = true;
            }
            if (set.contains("getRequiredOptions")) {
                this.__MgetRequiredOptions = true;
            }
            if (set.contains("getProbeManager")) {
                this.__MgetProbeManager = true;
            }
            if (set.contains("execute$java_lang_String$java_io_PrintStream$java_io_PrintStream")) {
                this.__Mexecute$java_lang_String$java_io_PrintStream$java_io_PrintStream = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

