/**
 * JASMINe
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: TargetCreateCommandParams.java 8733 2011-08-10 09:51:06Z danesa $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.probe.shell;

import java.util.ArrayList;
import java.util.List;

import com.beust.jcommander.Parameter;

public class TargetCreateCommandParams extends JasmineProbeCommandParams {

    @Parameter(description = "[properties]", required = false)
    public List<String> props = new ArrayList<String>();

    @Parameter(names = { "-n", "--name" }, description = "Name of the target to create", required = true)
    public String name = null;

    @Parameter(names = { "-u", "--url" }, description = "Url of the target to create", required = true)
    public String url = null;

    public String getName() {
        return name;
    }

    public String getUrl() {
        return url;
    }

    public List<String> getProps() {
        return props;
    }

    public void reset() {
        name = null;
        url = null;
        props.clear();
    }
}
