/**
 * JASMINe
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: CsvConverter.java 8547 2011-07-13 15:02:30Z durieuxp $
 * --------------------------------------------------------------------------
 */

package org.ow2.jasmine.probe.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;

/**
 * Utility converters from CSV format to various lists
 * @author durieuxp
 */
public class CsvConverter {

    /**
     * Build a Collection of String from a single csv String
     * @param csv with spaces replaced by underlines
     * @return
     */
    public static String[] csv2array(String csv) {
        if (csv == null) {
            return null;
        }
        StringTokenizer stk = new StringTokenizer(csv, ",");
        String[] ret = new String[stk.countTokens()];
        int i = 0;
        while (stk.hasMoreTokens()) {
            ret[i++] = stk.nextToken().trim().replace('_', ' ');
        }
        return ret;
    }

    /**
     * Build a Collection of String from a single csv String
     * @param csv
     * @return
     */
    public static Collection<String> csv2list(String csv) {
        if (csv == null) {
            return null;
        }
        StringTokenizer stk = new StringTokenizer(csv, ",");
        List<String> ret = new ArrayList<String>();
        while (stk.hasMoreTokens()) {
            ret.add(stk.nextToken().trim());
        }
        return ret;
    }

}
