/**
 * JASMINe
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: JCollectorService.java 8926 2011-09-16 15:04:22Z durieuxp $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.probe.collectors;

import org.ow2.jasmine.probe.JasmineIndicator;
import org.ow2.jasmine.probe.JasminePropertyInfo;
import org.ow2.jasmine.probe.collector.JasmineCollector;
import org.ow2.jasmine.probe.collector.JasmineCollectorException;
import org.ow2.jasmine.probe.collector.JasmineCollectorService;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Base class for Collector Service
 * @author durieuxp
 */
public abstract class JCollectorService implements JasmineCollectorService {

    /**
     * Logger.
     */
    protected Log logger = LogFactory.getLog(JCollector.class);

    /**
     * List of collectors
     */
    protected Map<String, JCollector> collectorList = new HashMap<String, JCollector>();

    /**
     * Info about Properties
     */
    protected List<JasminePropertyInfo> properties;

    abstract public JasmineCollector getCollector(JasmineIndicator indicator, int period, String probeid) throws JasmineCollectorException;

    /**
     * Remove Collectors attached to this Indicator.
     * Called usually when the indicator has changed or is removed.
     * @param name  Indicator name
     */
    public synchronized void removeCollectors(String name) {
        logger.debug(name);
        // Avoids ConcurrentModificationException
        List<String> toremove = new ArrayList<String>();
        for (String key : collectorList.keySet()) {
            JCollector coll = collectorList.get(key);
            if (coll.getIndicator().getName().equals(name)) {
                coll.stopPolling(); // just in case
                toremove.add(key);
            }
        }
        for (String rem : toremove) {
            collectorList.remove(rem);
        }
    }

    /**
     * Retrieve the description of all specific properties hidden in JasmineOutput
     * Return a Map of all properties with their description
     * @return  a Map of property descriptions
     */
    public List<JasminePropertyInfo> getPropertiesInfo() {
        return properties;
    }

    /**
     * return the List of indicators used by this indicator.
     * This default version return an empty list.
     * @param indic JasmineIndicator
     * @return
     */
    public List<String> getDependantIndicators(JasmineIndicator indic) {
        List<String> ret = new ArrayList<String>();
        return ret;
    }
}
