/**
 * JASMINe
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: JOuterService.java 8921 2011-09-16 13:46:34Z durieuxp $
 * --------------------------------------------------------------------------
 */

package org.ow2.jasmine.probe.outers;

import org.ow2.jasmine.probe.JasmineOutput;
import org.ow2.jasmine.probe.JasminePropertyInfo;
import org.ow2.jasmine.probe.outer.JasmineOuter;
import org.ow2.jasmine.probe.outer.JasmineOuterException;
import org.ow2.jasmine.probe.outer.JasmineOuterService;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Base class for all OuterServices
 * @author durieuxp
 */
public abstract class JOuterService implements JasmineOuterService {

    /**
     * Logger.
     */
    protected Log logger = LogFactory.getLog(JOuter.class);

    /**
     * List of Outer
     */
    protected Map<String, JOuter> outerList = new HashMap<String, JOuter>();

    protected List<JasminePropertyInfo> properties;

    // ---------------------------------------------------------------------
    //  JasmineOuterService implementation
    // ---------------------------------------------------------------------

    /**
     * Create an Outer for this JasmineOutput
     * @param jasmineOutput
     * @return the Outer
     * @throws JasmineOuterException operation failed
     */
    public abstract JasmineOuter getOuter(JasmineOutput jasmineOutput) throws JasmineOuterException;

    /**
     * Remove Outes attached to this Output.
     * Called usually when the output has changed or is removed.
     * @param name  Output name
     */
    public synchronized void removeOuters(String name) {
        logger.debug(name);
        // Avoids ConcurrentModificationException
        List<String> toremove = new ArrayList<String>();
        for (String key : outerList.keySet()) {
            JOuter outer = outerList.get(key);
            if (outer.getOutput().getName().equals(name)) {
                toremove.add(key);
            }
        }
        for (String rem : toremove) {
            outerList.remove(rem);
        }
    }

    /**
     * Retrieve the description of all specific properties hidden in JasmineOutput
     * Return a List of all properties with their description
     * @return  a List of property descriptions
     */
    public List<JasminePropertyInfo> getPropertiesInfo() {
        return properties;
    }
}
