/**
 * JASMINe
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: OutputListCommandParams.java 8733 2011-08-10 09:51:06Z danesa $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.probe.shell;

import com.beust.jcommander.Parameter;

public class OutputListCommandParams extends JasmineProbeCommandParams {

    @Parameter(names = { "-n", "--name" }, description = "Name of the output to show", required = false)
    public String name = null;

    @Parameter(names = { "-v", "--verbose" }, description = "If true, print details about outputs", required = false)
    private boolean verbose = false;


    @Parameter(names = { "-t", "--types" }, description = "List all the available output types", required = false)
    private boolean types = false;

    public boolean isTypes() {
        return types;
    }

    public String getName() {
        return name;
    }

    public boolean isVerbose() {
        return verbose;
    }

    public void reset() {
        name = null;
        verbose = false;
        types = false;
    }
}
