/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.shell;

import java.io.PrintStream;
import java.util.List;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.shell.Command;
import org.ow2.jasmine.probe.JasmineProbeManager;
import org.ow2.jasmine.probe.JasmineTarget;
import org.ow2.jasmine.probe.shell.JasmineProbeCommand;
import org.ow2.jasmine.probe.shell.TargetListCommandParams;

@Component(name="TargetListCommand")
@Provides
public class TargetListCommand
extends JasmineProbeCommand
implements Command,
Pojo {
    private InstanceManager __IM;
    private boolean __Fname;
    private String name;
    private boolean __Fdescription;
    private String description;
    private boolean __FprobeManager;
    @Requires
    JasmineProbeManager probeManager;
    private boolean __MgetName;
    private boolean __MgetShortDescription;
    private boolean __MgetProbeManager;
    private boolean __Mexecute$java_lang_String$java_io_PrintStream$java_io_PrintStream;
    private boolean __MlistTargets$boolean$java_io_PrintStream;
    private boolean __MshowTarget$java_lang_String$java_io_PrintStream$java_io_PrintStream;

    String __getname() {
        if (!this.__Fname) {
            return this.name;
        }
        return (String)this.__IM.onGet((Object)this, "name");
    }

    void __setname(String string) {
        if (!this.__Fname) {
            this.name = string;
            return;
        }
        this.__IM.onSet((Object)this, "name", (Object)string);
    }

    String __getdescription() {
        if (!this.__Fdescription) {
            return this.description;
        }
        return (String)this.__IM.onGet((Object)this, "description");
    }

    void __setdescription(String string) {
        if (!this.__Fdescription) {
            this.description = string;
            return;
        }
        this.__IM.onSet((Object)this, "description", (Object)string);
    }

    JasmineProbeManager __getprobeManager() {
        if (!this.__FprobeManager) {
            return this.probeManager;
        }
        return (JasmineProbeManager)this.__IM.onGet((Object)this, "probeManager");
    }

    void __setprobeManager(JasmineProbeManager jasmineProbeManager) {
        if (!this.__FprobeManager) {
            this.probeManager = jasmineProbeManager;
            return;
        }
        this.__IM.onSet((Object)this, "probeManager", (Object)jasmineProbeManager);
    }

    public TargetListCommand() {
        this(null);
    }

    private TargetListCommand(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setname("target-list");
        this.__setdescription("List all JASMINe Targets, or show a particular Target");
        this.__setprobeManager(null);
        this.setParams(new TargetListCommandParams());
    }

    public String getName() {
        String string;
        if (!this.__MgetName) {
            return this.__getName();
        }
        try {
            this.__IM.onEntry((Object)this, "getName", new Object[0]);
            string = this.__getName();
            this.__IM.onExit((Object)this, "getName", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getName", throwable);
            throw throwable;
        }
        return string;
    }

    private String __getName() {
        return this.__getname();
    }

    public String getShortDescription() {
        String string;
        if (!this.__MgetShortDescription) {
            return this.__getShortDescription();
        }
        try {
            this.__IM.onEntry((Object)this, "getShortDescription", new Object[0]);
            string = this.__getShortDescription();
            this.__IM.onExit((Object)this, "getShortDescription", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getShortDescription", throwable);
            throw throwable;
        }
        return string;
    }

    private String __getShortDescription() {
        return this.__getdescription();
    }

    public JasmineProbeManager getProbeManager() {
        JasmineProbeManager jasmineProbeManager;
        if (!this.__MgetProbeManager) {
            return this.__getProbeManager();
        }
        try {
            this.__IM.onEntry((Object)this, "getProbeManager", new Object[0]);
            jasmineProbeManager = this.__getProbeManager();
            this.__IM.onExit((Object)this, "getProbeManager", (Object)jasmineProbeManager);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getProbeManager", throwable);
            throw throwable;
        }
        return jasmineProbeManager;
    }

    private JasmineProbeManager __getProbeManager() {
        return this.__getprobeManager();
    }

    public void execute(String string, PrintStream printStream, PrintStream printStream2) {
        if (!this.__Mexecute$java_lang_String$java_io_PrintStream$java_io_PrintStream) {
            this.__execute(string, printStream, printStream2);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "execute$java_lang_String$java_io_PrintStream$java_io_PrintStream", new Object[]{string, printStream, printStream2});
            this.__execute(string, printStream, printStream2);
            this.__IM.onExit((Object)this, "execute$java_lang_String$java_io_PrintStream$java_io_PrintStream", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "execute$java_lang_String$java_io_PrintStream$java_io_PrintStream", throwable);
            throw throwable;
        }
    }

    private void __execute(String line, PrintStream out, PrintStream err) {
        boolean validOptions = this.parseOptions(line, out, err);
        if (!validOptions) {
            err.println(this.getUsage());
            return;
        }
        TargetListCommandParams params = (TargetListCommandParams)this.getParams();
        String targetName = params.getName();
        boolean verbose = params.getVerbose();
        if (targetName == null) {
            this.listTargets(verbose, out);
        } else {
            this.showTarget(targetName, out, err);
        }
        params.reset();
    }

    private void listTargets(boolean bl, PrintStream printStream) {
        if (!this.__MlistTargets$boolean$java_io_PrintStream) {
            this.__listTargets(bl, printStream);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "listTargets$boolean$java_io_PrintStream", new Object[]{new Boolean(bl), printStream});
            this.__listTargets(bl, printStream);
            this.__IM.onExit((Object)this, "listTargets$boolean$java_io_PrintStream", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "listTargets$boolean$java_io_PrintStream", throwable);
            throw throwable;
        }
    }

    private void __listTargets(boolean verbose, PrintStream out) {
        List targets = this.__getprobeManager().getTargets();
        if (targets.isEmpty()) {
            out.println("There are no JasmineTargets");
            return;
        }
        for (JasmineTarget target : targets) {
            if (verbose) {
                out.println(target.toString());
                out.println();
                continue;
            }
            out.println(target.getName());
        }
    }

    private void showTarget(String string, PrintStream printStream, PrintStream printStream2) {
        if (!this.__MshowTarget$java_lang_String$java_io_PrintStream$java_io_PrintStream) {
            this.__showTarget(string, printStream, printStream2);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "showTarget$java_lang_String$java_io_PrintStream$java_io_PrintStream", new Object[]{string, printStream, printStream2});
            this.__showTarget(string, printStream, printStream2);
            this.__IM.onExit((Object)this, "showTarget$java_lang_String$java_io_PrintStream$java_io_PrintStream", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "showTarget$java_lang_String$java_io_PrintStream$java_io_PrintStream", throwable);
            throw throwable;
        }
    }

    private void __showTarget(String targetName, PrintStream out, PrintStream err) {
        List targets = this.__getprobeManager().getTargets();
        for (JasmineTarget target : targets) {
            if (!targetName.equals(target.getName())) continue;
            out.println(target.toString());
            return;
        }
        err.println("There is no JasmineTarget named " + targetName);
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("probeManager")) {
                this.__FprobeManager = true;
            }
            if (set.contains("description")) {
                this.__Fdescription = true;
            }
            if (set.contains("name")) {
                this.__Fname = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("getName")) {
                this.__MgetName = true;
            }
            if (set.contains("getShortDescription")) {
                this.__MgetShortDescription = true;
            }
            if (set.contains("getProbeManager")) {
                this.__MgetProbeManager = true;
            }
            if (set.contains("execute$java_lang_String$java_io_PrintStream$java_io_PrintStream")) {
                this.__Mexecute$java_lang_String$java_io_PrintStream$java_io_PrintStream = true;
            }
            if (set.contains("listTargets$boolean$java_io_PrintStream")) {
                this.__MlistTargets$boolean$java_io_PrintStream = true;
            }
            if (set.contains("showTarget$java_lang_String$java_io_PrintStream$java_io_PrintStream")) {
                this.__MshowTarget$java_lang_String$java_io_PrintStream$java_io_PrintStream = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

