/**
 * JASMINe
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: ProbeChangeCommandParams.java 9655 2012-01-24 08:06:29Z danesa $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.probe.shell;

import java.util.ArrayList;
import java.util.List;

import com.beust.jcommander.Parameter;

/**
 * Parameters for probe-change command.
 * @author danesa
 */
public class ProbeChangeCommandParams extends JasmineProbeCommandParams {


    @Parameter(names = { "-n", "--name" }, description = "Probe name", required = true)
    public String name = null;

    @Parameter(names = { "-i", "--indicators" }, description = "Indicator names", required = false)
    private List<String> indicators = new ArrayList<String>();

    @Parameter(names = { "-o", "--outputs" }, description = "Output names", required = false)
    private List<String> outputs = new ArrayList<String>();

    @Parameter(names = { "-t", "--targets" }, description = "Target names", required = false)
    private List<String> targets = new ArrayList<String>();

    // Default value for period is 10s
    @Parameter(names = { "-p", "--period" }, description = "Execution period in seconds", required = false)
    private int period = -1;

    public String getName() {
        return name;
    }

    public List<String> getIndicators() {
        return indicators;
    }

    public List<String> getOutputs() {
        return outputs;
    }

    public List<String> getTargets() {
        return targets;
    }

    public int getPeriod() {
        return period;
    }

    public void reset() {
        name = null;
        period = -1;
        indicators.clear();
        outputs.clear();
        targets.clear();
    }
}
