/**
 * JASMINe
 * Copyright (C) 2012 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: ProbeConfigLoadSaveCommandParams.java 9710 2012-01-31 15:09:06Z danesa $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.probe.shell;

import com.beust.jcommander.Parameter;

/**
 * Parameters for probe-config-save and probe-config-load commands.
 * @author danesa
 */
public class ProbeConfigLoadSaveCommandParams extends JasmineProbeCommandParams {


    @Parameter(names = { "-f", "--file" }, description = "Configuration file name", required = true)
    public String file = null;

    public String getFile() {
        return file;
    }

    public void reset() {
        file = null;
    }
}
