/**
 * JASMINe
 * Copyright (C) 2011-2012 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 */
package org.ow2.jasmine.probe.shell;

import java.util.ArrayList;
import java.util.List;

import com.beust.jcommander.Parameter;

public class IndicatorChangeCommandParams extends JasmineProbeCommandParams {

    @Parameter(names = { "-n", "--name" }, description = "Name of the indicator to change", required = true)
    public String name = null;

    @Parameter(names = { "-t", "--type" }, description = "New type for the indicator", required = false)
    public String type = null;

    @Parameter(names = { "-i", "--indicators" }, variableArity = true, description = "New source indicators", required = false)
    public List<String> sources =  new ArrayList<String>();

    @Parameter(names = { "-s", "--scale" }, description = "New scale for the indicator", required = false)
    public int scale = 1;

    @Parameter(names = { "-d", "--define" }, splitter = NoSplitter.class, variableArity = true,
            description = "Indicator properties to be re-defined, given in key=value format", required = false)
    public List<String> props = new ArrayList<String>();

    public String getName() {
        return name;
    }

    public String getType() {
        return type;
    }

    public List<String> getSources() {
        return sources;
    }

    public List<String> getProps() {
        return props;
    }

    public int getScale() {
        return scale;
    }

    public void reset() {
        name = null;
        type = null;
        scale = 1;
        sources.clear();
        props.clear();
    }
}
