/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.collectors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ow2.jasmine.probe.JasmineCollectorInfo;
import org.ow2.jasmine.probe.JasmineIndicator;
import org.ow2.jasmine.probe.JasmineProbe;
import org.ow2.jasmine.probe.JasminePropertyInfo;
import org.ow2.jasmine.probe.collector.JasmineCollector;
import org.ow2.jasmine.probe.collector.JasmineCollectorException;
import org.ow2.jasmine.probe.collector.JasmineCollectorService;
import org.ow2.jasmine.probe.collectors.JCollector;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public abstract class JCollectorService
implements JasmineCollectorService {
    protected Log logger = LogFactory.getLog(JCollector.class);
    Map<String, List<JCollector>> collectorsList = new HashMap<String, List<JCollector>>();
    protected List<JasminePropertyInfo> properties;
    protected JasmineCollectorInfo collectorInfo;

    public abstract JasmineCollector getCollector(JasmineIndicator var1, JasmineProbe var2) throws JasmineCollectorException;

    public synchronized void removeCollectors(String name, String probeId) {
        if (name == null) {
            String[] indicatorNames;
            this.logger.debug((Object)"Remove all the collectors corresponding to {0} indicators", new Object[]{this.getType()});
            for (String indicatorName : indicatorNames = this.collectorsList.keySet().toArray(new String[0])) {
                this.removeCollectors(indicatorName);
            }
            return;
        }
        if (probeId == null) {
            this.logger.debug((Object)name, new Object[0]);
            this.removeCollectors(name);
        } else {
            this.logger.debug((Object)(name + " in " + probeId), new Object[0]);
            this.removeCollector(name, probeId);
        }
    }

    public synchronized void removeTarget(String name) {
    }

    private void removeCollectors(String name) {
        this.logger.debug((Object)name, new Object[0]);
        if (this.collectorsList.isEmpty()) {
            return;
        }
        List<JCollector> colls = this.collectorsList.get(name);
        for (JCollector coll : colls) {
            coll.stopPolling();
            coll.remove();
        }
        this.collectorsList.remove(name);
    }

    private void removeCollector(String name, String probeId) {
        ArrayList<JCollector> toRemove = new ArrayList<JCollector>();
        List<JCollector> colls = this.collectorsList.get(name);
        for (JCollector coll : colls) {
            if (coll.probeId != probeId) continue;
            toRemove.add(coll);
        }
        for (JCollector coll : toRemove) {
            coll.stopPolling();
            coll.remove();
            colls.remove(coll);
        }
    }

    protected synchronized void addCollector(String name, JCollector coll) {
        this.logger.debug((Object)name, new Object[0]);
        if (!this.collectorsList.containsKey(name)) {
            this.collectorsList.put(name, new ArrayList());
        }
        this.collectorsList.get(name).add(coll);
    }

    protected synchronized JCollector getCollector(String name, String probeId) {
        this.logger.debug((Object)name, new Object[0]);
        List<JCollector> colls = this.collectorsList.get(name);
        if (colls == null) {
            return null;
        }
        for (int i = 0; i < colls.size(); ++i) {
            JCollector coll = colls.get(i);
            if (!probeId.equals(coll.probeId)) continue;
            return coll;
        }
        return null;
    }

    public List<JasminePropertyInfo> getPropertiesInfo() {
        return this.properties;
    }

    public JasmineCollectorInfo getCollectorInfo() {
        return this.collectorInfo;
    }

    public List<String> getDependantIndicators(JasmineIndicator indic) {
        ArrayList<String> ret = new ArrayList<String>();
        return ret;
    }

    public List<String> getDependantTargets(JasmineIndicator indic) {
        ArrayList<String> ret = new ArrayList<String>();
        return ret;
    }

    public String getType() {
        return this.collectorInfo.getType();
    }
}

