/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.outers;

import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.ow2.jasmine.probe.JasmineIndicatorValue;
import org.ow2.jasmine.probe.JasmineOutput;
import org.ow2.jasmine.probe.JasmineProbeResult;
import org.ow2.jasmine.probe.JasmineSingleResult;
import org.ow2.jasmine.probe.outer.JasmineOuter;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public abstract class JOuter
extends Thread
implements JasmineOuter {
    protected Log logger = LogFactory.getLog(JOuter.class);
    private Queue<JasmineProbeResult> dataqueue = new ConcurrentLinkedQueue<JasmineProbeResult>();
    protected static final String SEPARATOR = ";";
    protected JasmineOutput output;
    private boolean valid = true;
    private int totalRetrievedData = 0;
    private int nbConsumerCycle = 100;
    private int totalInsertedData = 0;
    private int nbProducerCycle = 100;
    protected SimpleDateFormat dateformat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    private boolean removed = false;

    public abstract void processData(JasmineProbeResult var1);

    public JOuter(JasmineOutput output) {
        super("JasmineOuter-" + output.getName());
        this.output = output;
    }

    public JasmineOutput getOutput() {
        return this.output;
    }

    @Override
    public void run() {
        while (this.valid) {
            JasmineProbeResult data = null;
            data = this.dataqueue.poll();
            if (data == null) continue;
            if (this.logger.isDebugEnabled()) {
                --this.nbConsumerCycle;
                ++this.totalRetrievedData;
                if (this.nbConsumerCycle <= 0) {
                    this.nbConsumerCycle = 100;
                    this.logger.debug((Object)"Monitoring {0} output : Total number of retrieved data = {1}, Data queue size = {2}", new Object[]{this.output.getName(), this.totalRetrievedData, this.dataqueue.size()});
                }
            }
            this.processData(data);
        }
    }

    public synchronized void stopIt() {
        this.valid = false;
        this.notify();
    }

    public void flushData() {
    }

    public String composeName(JasmineIndicatorValue jiv, String jsrName) {
        StringBuffer name = new StringBuffer(jiv.getName());
        if (jiv.isMultiValue() && jsrName != null && jsrName.length() != 0) {
            name.append(".");
            name.append(jsrName);
        }
        return name.toString();
    }

    public String findMbean(JasmineSingleResult jsr) {
        String mbean = null;
        HashMap resultProps = jsr.getProperties();
        if (!resultProps.isEmpty()) {
            for (String key : resultProps.keySet()) {
                if (!"mbean".equals(key)) continue;
                mbean = (String)resultProps.get(key);
            }
        }
        if (mbean == null) {
            mbean = "misc:type=correlate";
        }
        return mbean;
    }

    public String getOutputName() {
        return this.getOutput().getName();
    }

    public synchronized void publishData(JasmineProbeResult result) {
        this.dataqueue.offer(result);
        if (this.logger.isDebugEnabled()) {
            --this.nbProducerCycle;
            ++this.totalInsertedData;
            if (this.nbProducerCycle <= 0) {
                this.nbProducerCycle = 100;
                this.logger.debug((Object)"Monitoring {0} output : Total number of inserted data = {1}, Data queue size = {2}", new Object[]{this.output.getName(), this.totalInsertedData, this.dataqueue.size()});
            }
        }
    }

    protected String outputProps(String output, HashMap<String, String> props, String separator) {
        String result = output;
        for (String key : props.keySet()) {
            if (result.length() > 0) {
                result = result + separator;
            }
            result = result + key + "=" + props.get(key);
        }
        return result;
    }

    public void remove() {
        this.logger.debug((Object)("Mark removed " + this.getName()), new Object[0]);
        this.removed = true;
    }

    public boolean isRemoved() {
        return this.removed;
    }
}

