/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.collectors;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.management.ObjectName;
import org.ow2.jasmine.probe.JasmineIndicator;
import org.ow2.jasmine.probe.JasmineIndicatorValue;
import org.ow2.jasmine.probe.JasmineSingleBooleanResult;
import org.ow2.jasmine.probe.JasmineSingleNumberResult;
import org.ow2.jasmine.probe.JasmineSingleObjectNameResult;
import org.ow2.jasmine.probe.JasmineSingleResult;
import org.ow2.jasmine.probe.JasmineSingleStringResult;
import org.ow2.jasmine.probe.collector.JasmineCollector;
import org.ow2.jasmine.probe.collector.JasmineCollectorException;
import org.ow2.jasmine.probe.probemanager.ProbeManager;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public abstract class JCollector
implements JasmineCollector {
    protected Log logger = LogFactory.getLog(JCollector.class);
    protected JasmineIndicator indicator;
    protected int period;
    protected String probeId;
    protected ProbeManager probeManager = null;
    protected String hostName = null;
    private boolean removed = false;
    protected final String NO_TARGET = "none";
    protected final String MISC_TARGET = "misc";

    public void remove() {
        this.logger.debug((Object)("Mark removed " + this.indicator.getName() + " in probe " + this.probeId), new Object[0]);
        this.removed = true;
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public JCollector(String probeId, JasmineIndicator def, int period) {
        this.indicator = def;
        this.period = period;
        this.probeId = probeId;
        try {
            this.hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            this.logger.warn((Object)"Cannot get host name for indicator {0} ({1})", new Object[]{def.getName(), e.toString()});
        }
    }

    public JasmineIndicator getIndicator() {
        return this.indicator;
    }

    public void setProbeManager(ProbeManager probeManager) {
        this.probeManager = probeManager;
    }

    protected String getDomainName() {
        return this.probeManager.getDomainName();
    }

    protected String getServerName() {
        return this.probeManager.getServerName();
    }

    public String getIndicatorName() {
        return this.getIndicator().getName();
    }

    public String getProbeId() {
        return this.probeId;
    }

    public abstract JasmineIndicatorValue getLastResult() throws JasmineCollectorException;

    public abstract void stopPolling();

    public abstract void startPolling();

    protected String getDefaultTarget() {
        String targetName = this.hostName;
        if (targetName == null) {
            targetName = this.getServerName();
        }
        return targetName;
    }

    protected JasmineSingleResult getJsr(String name, Object value, long timestamp, int scale) throws JasmineCollectorException {
        JasmineSingleStringResult jsr = null;
        if (value instanceof String) {
            String s = (String)value;
            jsr = new JasmineSingleStringResult();
            jsr.setValue((Object)s);
        } else if (value instanceof Boolean) {
            Boolean b = (Boolean)value;
            jsr = new JasmineSingleBooleanResult();
            jsr.setValue((Object)b);
        } else if (value instanceof ObjectName) {
            ObjectName on = (ObjectName)value;
            jsr = new JasmineSingleObjectNameResult();
            jsr.setValue((Object)on);
        } else {
            try {
                Number numberValue = (Number)value;
                jsr = new JasmineSingleNumberResult();
                if (scale != 1) {
                    numberValue = this.divideValues(numberValue, scale);
                }
                jsr.setValue((Object)numberValue);
            }
            catch (ClassCastException cce) {
                this.logger.warn((Object)("Attribute " + name + " is not a number, nor a String. Currently no result (JasmineSingleResult) returned for it !"), new Object[0]);
                return null;
            }
        }
        jsr.setName(name);
        jsr.setTimestamp(timestamp);
        return jsr;
    }

    private Number max(Collection<Number> coll) throws JasmineCollectorException {
        Number ret = null;
        for (Number val : coll) {
            if (ret == null) {
                ret = val;
                continue;
            }
            Number diff = this.diffValues(val, ret);
            if (this.castLong(diff)) {
                if (diff.longValue() <= 0L) continue;
                ret = val;
                continue;
            }
            if (diff instanceof Float) {
                if (!(diff.floatValue() > 0.0f)) continue;
                ret = val;
                continue;
            }
            if (!(diff instanceof Double) || !(diff.doubleValue() > 0.0)) continue;
            ret = val;
        }
        return ret;
    }

    protected Number maxJsr(Collection<JasmineSingleResult> jsrs) throws JasmineCollectorException {
        try {
            Collection<Number> numList = this.getNumList(jsrs);
            return this.max(numList);
        }
        catch (ClassCastException ce) {
            throw new JasmineCollectorException("Aggregation of incompatible types (max operation expects only Number values)");
        }
    }

    private Number min(Collection<Number> coll) throws JasmineCollectorException {
        Number ret = null;
        for (Number val : coll) {
            if (ret == null) {
                ret = val;
                continue;
            }
            Number diff = this.diffValues(val, ret);
            if (this.castLong(diff)) {
                if (diff.longValue() >= 0L) continue;
                ret = val;
                continue;
            }
            if (diff instanceof Float) {
                if (!(diff.floatValue() < 0.0f)) continue;
                ret = val;
                continue;
            }
            if (!(diff instanceof Double) || !(diff.doubleValue() < 0.0)) continue;
            ret = val;
        }
        return ret;
    }

    protected Number minJsr(Collection<JasmineSingleResult> jsrs) throws JasmineCollectorException {
        try {
            Collection<Number> numList = this.getNumList(jsrs);
            return this.min(numList);
        }
        catch (ClassCastException ce) {
            throw new JasmineCollectorException("Aggregation of incompatible types (min operation expects only Number values)");
        }
    }

    private Number average(Collection<Number> coll) throws JasmineCollectorException {
        Number ret = this.addValues(coll);
        int nbval = coll.size();
        if (this.castLong(ret)) {
            return Float.valueOf((float)ret.doubleValue() / (float)nbval);
        }
        if (ret instanceof Float) {
            return Float.valueOf(ret.floatValue() / (float)nbval);
        }
        if (ret instanceof Double) {
            double dret = ret.doubleValue();
            return dret / (double)nbval;
        }
        throw new JasmineCollectorException("Unsupported values in a collection of numbers for average operation");
    }

    protected Number averageJsr(Collection<JasmineSingleResult> jsrs) throws JasmineCollectorException {
        try {
            Collection<Number> numList = this.getNumList(jsrs);
            return this.average(numList);
        }
        catch (ClassCastException ce) {
            throw new JasmineCollectorException("Aggregation of incompatible types (min operation expects only Number values)");
        }
    }

    protected long diffLongValues(Number v1, Number v2) throws JasmineCollectorException {
        return this.longValue(v1) - this.longValue(v2);
    }

    protected Number diffJsr(Collection<JasmineSingleResult> jsrs) throws JasmineCollectorException {
        if (jsrs.size() != 2) {
            throw new JasmineCollectorException("Diff correlation with more that 2 values not supported");
        }
        JasmineSingleResult jsr1 = null;
        JasmineSingleResult jsr2 = null;
        for (JasmineSingleResult jsr : jsrs) {
            if (jsr1 == null) {
                jsr1 = jsr;
                continue;
            }
            jsr2 = jsr;
        }
        try {
            Number num1 = (Number)jsr1.getValue();
            Number num2 = (Number)jsr2.getValue();
            return this.diffValues(num1, num2);
        }
        catch (ClassCastException ce) {
            throw new JasmineCollectorException("Correlation of incompatible types (diff operation expects only Number values)");
        }
    }

    protected float divideLongValues(Number v1, Number v2) throws JasmineCollectorException {
        if (this.longValue(v2) == 0L) {
            return 1.0f;
        }
        return this.longValue(v1) / this.longValue(v2);
    }

    protected Number divideValues(Number v1, Number v2) throws JasmineCollectorException {
        if (this.castLong(v2) ? this.longValue(v2) == 0L : (v2 instanceof Float || v2 instanceof Double) && v2.doubleValue() == 0.0) {
            return 1;
        }
        return v1.doubleValue() / v2.doubleValue();
    }

    protected Number divideJsr(Collection<JasmineSingleResult> jsrs) throws JasmineCollectorException {
        if (jsrs.size() != 2) {
            throw new JasmineCollectorException("Diff correlation with more that 2 values not supported");
        }
        JasmineSingleResult jsr1 = null;
        JasmineSingleResult jsr2 = null;
        for (JasmineSingleResult jsr : jsrs) {
            if (jsr1 == null) {
                jsr1 = jsr;
                continue;
            }
            jsr2 = jsr;
        }
        try {
            Number num1 = (Number)jsr1.getValue();
            Number num2 = (Number)jsr2.getValue();
            return this.divideValues(num1, num2);
        }
        catch (ClassCastException ce) {
            throw new JasmineCollectorException("Correlation of incompatible types (divide operation expects only Number values)");
        }
    }

    protected Number addValues(Collection<Number> values) throws JasmineCollectorException {
        long longRes = 0L;
        float floatRes = 0.0f;
        double doubleRes = 0.0;
        boolean isFloat = false;
        boolean isDouble = false;
        for (Number o : values) {
            if (this.castLong(o)) {
                longRes += o.longValue();
                continue;
            }
            if (o instanceof Float) {
                isFloat = true;
                floatRes += o.floatValue();
                continue;
            }
            if (o instanceof Double) {
                isDouble = true;
                doubleRes += o.doubleValue();
                continue;
            }
            throw new JasmineCollectorException("This Number cannot be converted to a long or to a float: " + o);
        }
        if (isDouble) {
            double res = doubleRes + (double)floatRes + (double)longRes;
            return res;
        }
        if (isFloat) {
            float res = floatRes + (float)longRes;
            return Float.valueOf(res);
        }
        return longRes;
    }

    protected Number diffValues(Number v1, Number v2) throws JasmineCollectorException {
        if (this.castLong(v1) && this.castLong(v2)) {
            return this.longValue(v1) - this.longValue(v2);
        }
        if (v1 instanceof Float || v1 instanceof Double) {
            double d_v1 = v1.doubleValue();
            if (this.castLong(v2)) {
                return d_v1 - (double)v2.longValue();
            }
            if (v2 instanceof Float) {
                return d_v1 - (double)v2.floatValue();
            }
            if (v2 instanceof Double) {
                return d_v1 - v2.doubleValue();
            }
            throw new JasmineCollectorException("This Number cannot be converted to a long or to a float: " + v2);
        }
        if (this.castLong(v1)) {
            if (v2 instanceof Float) {
                return Float.valueOf(v1.floatValue() - v2.floatValue());
            }
            if (v2 instanceof Double) {
                return v1.doubleValue() - v2.doubleValue();
            }
            throw new JasmineCollectorException("This Number cannot be converted to a long or to a float: " + v2);
        }
        throw new JasmineCollectorException("This Number cannot be converted to a long or to a float: " + v1);
    }

    protected long addLongValues(Collection<Number> values) throws JasmineCollectorException {
        long ret = 0L;
        for (Number o : values) {
            ret += this.longValue(o);
        }
        return ret;
    }

    protected long addLongJsr(Collection<JasmineSingleResult> jsrs) throws JasmineCollectorException {
        try {
            Collection<Number> numList = this.getNumList(jsrs);
            return this.addLongValues(numList);
        }
        catch (ClassCastException ce) {
            throw new JasmineCollectorException("Correlation of incompatible types (add operation expects only Number values)");
        }
    }

    protected Number addJsr(Collection<JasmineSingleResult> jsrs) throws JasmineCollectorException {
        try {
            Collection<Number> numList = this.getNumList(jsrs);
            return this.addValues(numList);
        }
        catch (ClassCastException ce) {
            throw new JasmineCollectorException("Correlation of incompatible types (add operation expects only Number values)");
        }
    }

    protected long multiplyLongValues(Collection<Number> values) throws JasmineCollectorException {
        long ret = 1L;
        for (Number o : values) {
            ret *= this.longValue(o);
        }
        return ret;
    }

    protected Number multiplyValues(Collection<Number> values) throws JasmineCollectorException {
        long longRes = 1L;
        float floatRes = 1.0f;
        double doubleRes = 1.0;
        boolean isFloat = false;
        boolean isDouble = false;
        for (Number o : values) {
            if (this.castLong(o)) {
                longRes *= o.longValue();
                continue;
            }
            if (o instanceof Float) {
                isFloat = true;
                floatRes *= o.floatValue();
                continue;
            }
            if (o instanceof Double) {
                isDouble = true;
                doubleRes *= o.doubleValue();
                continue;
            }
            throw new JasmineCollectorException("This Number cannot be converted to a long or to a float: " + o);
        }
        if (isDouble) {
            double res = doubleRes * (double)floatRes * (double)longRes;
            return res;
        }
        if (isFloat) {
            float res = floatRes * (float)longRes;
            return Float.valueOf(res);
        }
        return longRes;
    }

    protected Number multiplyJsr(Collection<JasmineSingleResult> jsrs) throws JasmineCollectorException {
        try {
            Collection<Number> numList = this.getNumList(jsrs);
            return this.multiplyValues(numList);
        }
        catch (ClassCastException ce) {
            throw new JasmineCollectorException("Correlation of incompatible types (multiply operation expects only Number values)");
        }
    }

    private Collection<Number> getNumList(Collection<JasmineSingleResult> jsrs) throws ClassCastException {
        ArrayList<Number> numList = new ArrayList<Number>();
        for (JasmineSingleResult jsr : jsrs) {
            Number value = (Number)jsr.getValue();
            numList.add(value);
        }
        return numList;
    }

    protected long longValue(Number nb) throws JasmineCollectorException {
        long val;
        if (nb instanceof Integer) {
            val = ((Integer)nb).longValue();
        } else if (nb instanceof Long) {
            val = (Long)nb;
        } else if (nb instanceof Short) {
            val = ((Short)nb).longValue();
        } else {
            throw new JasmineCollectorException("This Number cannot be converted to a long: " + nb);
        }
        return val;
    }

    protected HashMap<String, String> jsrProps(Collection<JasmineSingleResult> jsrs) {
        HashMap<String, String> jsrProps = new HashMap<String, String>();
        for (JasmineSingleResult jsr : jsrs) {
            jsrProps.putAll(jsr.getProperties());
        }
        return jsrProps;
    }

    private boolean castLong(Number nb) {
        if (nb instanceof Integer) {
            return true;
        }
        if (nb instanceof Long) {
            return true;
        }
        return nb instanceof Short;
    }
}

