/**
 * JASMINe
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: JConsoleOuter.java 8589 2011-07-20 09:02:30Z durieuxp $
 * --------------------------------------------------------------------------
 */

package org.ow2.jasmine.probe.outers.console.internal;

import org.ow2.jasmine.probe.JasmineIndicValue;
import org.ow2.jasmine.probe.JasmineOutput;
import org.ow2.jasmine.probe.JasmineProbeResult;
import org.ow2.jasmine.probe.JasmineSingleResult;
import org.ow2.jasmine.probe.outers.JOuter;

/**
 * Outer implementation for console.
 * @author durieuxp
 */
public class JConsoleOuter extends JOuter {

    /**
     * Constructor
     * @param output definition
     */
    public JConsoleOuter(JasmineOutput output) {
        super(output);
        // there is no additional information in case of Console Outer
    }

    /**
     * Publish data on this Output
     * @param result data to publish
     */
    public void processData(JasmineProbeResult result) {
        logger.debug("probeid=" + result.getProbeId());
        logger.debug("nb values=" + result.getValues().size());
        for (JasmineIndicValue jiv : result.getValues()) {
            logger.debug("nb results=" + jiv.getValues().size());
            for (JasmineSingleResult jsr : jiv.getValues()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append(jsr.getTimestamp());
                buffer.append(SEPARATOR);
                buffer.append(dateformat.format(jsr.getTimestamp()));
                buffer.append(SEPARATOR);
                buffer.append(jsr.getName());
                buffer.append(SEPARATOR);
                buffer.append(jsr.getValue());
                // TODO Add metadata and properties
                System.out.println(buffer.toString());
            }
        }
    }

}
