/**
 * JASMINe
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: ConsoleOuterService.java 8909 2011-09-16 08:43:07Z durieuxp $
 * --------------------------------------------------------------------------
 */

package org.ow2.jasmine.probe.outers.console.internal;

import org.apache.felix.ipojo.annotations.*;
import org.ow2.jasmine.probe.JasmineOutput;
import org.ow2.jasmine.probe.JasminePropertyInfo;
import org.ow2.jasmine.probe.outer.JasmineOuter;
import org.ow2.jasmine.probe.outer.JasmineOuterException;
import org.ow2.jasmine.probe.outers.JOuter;
import org.ow2.jasmine.probe.outers.JOuterService;

import java.util.ArrayList;

/**
 * Manages a list of Outer objects.
 * @author durieuxp
 */
@Component(name="ConsoleOuterService")
@Provides
public class ConsoleOuterService extends JOuterService {

    @ServiceProperty(name="output.type", value="console")
    private String outputType;

    @Validate
    public void start() {
        // init the list of properties
        properties = new ArrayList<JasminePropertyInfo>();
    }

    @Invalidate
    public void stop() {
    }

    // --------------------------------------------------------------------------------
    //  JasmineOuterService implementation
    // --------------------------------------------------------------------------------

    /**
     * Create an Outer for this JasmineOutput
     * @param jasmineOutput
     * @return the Outer
     * @throws JasmineOuterException operation failed
     */
    public synchronized JasmineOuter getOuter(JasmineOutput jasmineOutput) throws JasmineOuterException {
        String name = jasmineOutput.getName();
        JOuter outer = outerList.get(name);
        if (outer == null) {
            outer = new JConsoleOuter(jasmineOutput);
            outerList.put(name, outer);
            outer.start();
        }
        return outer;
    }

}
