/**
 * JASMINe
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: JConsoleOuter.java 8995 2011-09-27 07:16:35Z durieuxp $
 * --------------------------------------------------------------------------
 */

package org.ow2.jasmine.probe.outers.console.internal;

import org.ow2.jasmine.probe.JasmineIndicatorValue;
import org.ow2.jasmine.probe.JasmineOutput;
import org.ow2.jasmine.probe.JasmineProbeResult;
import org.ow2.jasmine.probe.JasmineSingleResult;
import org.ow2.jasmine.probe.outers.JOuter;

/**
 * Outer implementation for console.
 * @author durieuxp
 */
public class JConsoleOuter extends JOuter {

    /**
     * Constructor
     * @param output definition
     */
    public JConsoleOuter(JasmineOutput output) {
        super(output);
        // there is no additional information in case of Console Outer
    }

    /**
     * Publish data on this Output
     * @param result data to publish
     */
    public void processData(JasmineProbeResult result) {
        logger.debug("probeid=" + result.getProbeId());
        logger.debug("nb values=" + result.getValues().size());
        for (JasmineIndicatorValue jiv : result.getValues()) {
            // Get metadata
            String metadata = "";
            for (String key : jiv.getMetadata().keySet()) {
                if (metadata.length() > 0) {
                    metadata += ",";
                }
                metadata += key + "=" + jiv.getMetadata().get(key);
            }
            // print values, one per line.
            int nbValues = jiv.getValues().size();
            logger.debug("nb results=" + nbValues);
            // The name to be printed for each value is the indicator name,
            // or a name composed from the indicator name and each JSR's name
            String indicatorName = jiv.getName();
            boolean simpleName = simpleDataName(indicatorName, jiv.getValues());
            for (JasmineSingleResult jsr : jiv.getValues()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append(result.getProbeId());
                buffer.append(SEPARATOR);
                buffer.append(jsr.getTimestamp());
                buffer.append(SEPARATOR);
                buffer.append(dateformat.format(jsr.getTimestamp()));
                buffer.append(SEPARATOR);
                buffer.append(jiv.getTarget());
                buffer.append(SEPARATOR);
                String name = null;
                if (simpleName) {
                    name = indicatorName;
                } else {
                    name = composeName(indicatorName, jsr.getName());
                }
                buffer.append(name);
                buffer.append(SEPARATOR);
                buffer.append(jsr.getValue());
                buffer.append(SEPARATOR);
                String metaAndProps = metadata;
                for (String prop : jsr.getProperties().keySet()) {
                     if (metaAndProps.length() > 0) {
                         metaAndProps += ",";
                     }
                     metaAndProps += prop + "=" + jsr.getProperties().get(prop);
                }
                buffer.append(metaAndProps);
                System.out.println(buffer.toString());
            }
        }
    }

}
