/**
 * JASMINe
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: JFileOuter.java 8542 2011-07-13 14:58:50Z durieuxp $
 * --------------------------------------------------------------------------
 */

package org.ow2.jasmine.probe.outers.file.internal;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;

import org.ow2.jasmine.probe.JasmineIndicValue;
import org.ow2.jasmine.probe.JasmineOutput;
import org.ow2.jasmine.probe.JasmineProbeResult;
import org.ow2.jasmine.probe.JasmineSingleResult;
import org.ow2.jasmine.probe.outers.JOuter;

/**
 * Outer implementation for file.
 * @author durieuxp
 */
public class JFileOuter extends JOuter {

    /**
     * file path
     */
    private String path = null;

    /**
     * PrintWriter used to write in the File
     */
    private PrintWriter pw = null;

    /**
     * Constructor
     * @param output definition
     */
    public JFileOuter(JasmineOutput output) {
        super(output);
        // specific part of JasmineOutput (property list)
        Map<String, String> props = output.getProperties();
        this.path = props.get("path");
        File f = new File(path);
        try {
            pw = new PrintWriter(new FileWriter(f), true);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    /**
     * Publish data on this Output
     * @param result data to publish
     */
    public void processData(JasmineProbeResult result) {
        for (JasmineIndicValue jiv : result.getValues()) {
            for (JasmineSingleResult jsr : jiv.getValues()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append(jsr.getTimestamp());
                buffer.append(SEPARATOR);
                buffer.append(dateformat.format(jsr.getTimestamp()));
                buffer.append(SEPARATOR);
                buffer.append(jsr.getName());
                buffer.append(SEPARATOR);
                buffer.append(jsr.getValue());
                // TODO Add metadata and properties
                pw.println(buffer.toString());
            }
        }
    }

}
