/**
 * JASMINe
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: JFileOuter.java 8848 2011-09-13 08:10:24Z danesa $
 * --------------------------------------------------------------------------
 */

package org.ow2.jasmine.probe.outers.file.internal;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;

import org.ow2.jasmine.probe.JasmineIndicatorValue;
import org.ow2.jasmine.probe.JasmineOutput;
import org.ow2.jasmine.probe.JasmineProbeResult;
import org.ow2.jasmine.probe.JasmineSingleResult;
import org.ow2.jasmine.probe.outers.JOuter;

/**
 * Outer implementation for file.
 * @author durieuxp
 */
public class JFileOuter extends JOuter {

    /**
     * file path
     */
    private String path = null;

    /**
     * PrintWriter used to write in the File
     */
    private PrintWriter pw = null;

    /**
     * Constructor
     * @param output definition
     */
    public JFileOuter(JasmineOutput output) {
        super(output);
        // specific part of JasmineOutput (property list)
        Map<String, String> props = output.getProperties();
        this.path = props.get("path");
        File f = new File(path);
        try {
            pw = new PrintWriter(new FileWriter(f), true);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    /**
     * Publish data on this Output
     * @param result data to publish
     */
    public void processData(JasmineProbeResult result) {
        for (JasmineIndicatorValue jiv : result.getValues()) {
            // Get metadata
            String metadata = "";
            for (String key : jiv.getMetadata().keySet()) {
                if (metadata.length() > 0) {
                    metadata += ",";
                }
                metadata += key + "=" + jiv.getMetadata().get(key);
            }
            // The name to be published for each value is the indicator name,
            // or a name composed from the indicator name and each JSR's name
            boolean simpleName = simpleDataName(jiv.getName(), jiv.getValues());
            for (JasmineSingleResult jsr : jiv.getValues()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append(jsr.getTimestamp());
                buffer.append(SEPARATOR);
                buffer.append(dateformat.format(jsr.getTimestamp()));
                buffer.append(SEPARATOR);
                String name = null;
                if (simpleName) {
                    name = jiv.getName();
                } else {
                    name = composeName(name, jsr.getName());
                }
                buffer.append(name);
                buffer.append(SEPARATOR);
                buffer.append(jsr.getValue());
                buffer.append(SEPARATOR);
                String metaAndProps = metadata;
                for (String prop : jsr.getProperties().keySet()) {
                     if (metaAndProps.length() > 0) {
                         metaAndProps += ",";
                     }
                     metaAndProps += prop + "=" + jsr.getProperties().get(prop);
                }
                buffer.append(metaAndProps);
                // TODO Add metadata and properties
                pw.println(buffer.toString());
            }
        }
    }

}
