/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.outers.file.internal;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Map;
import org.ow2.jasmine.probe.JasmineIndicatorValue;
import org.ow2.jasmine.probe.JasmineOutput;
import org.ow2.jasmine.probe.JasmineProbeResult;
import org.ow2.jasmine.probe.JasmineSingleResult;
import org.ow2.jasmine.probe.outers.JOuter;

public class JFileOuter
extends JOuter {
    private String path = null;
    private PrintWriter pw = null;

    public JFileOuter(JasmineOutput output) {
        super(output);
        Map props = output.getProperties();
        this.path = (String)props.get("path");
        File f = new File(this.path);
        try {
            this.pw = new PrintWriter((Writer)new FileWriter(f), true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void processData(JasmineProbeResult result) {
        for (JasmineIndicatorValue jiv : result.getValues()) {
            String metadata = "";
            for (String key : jiv.getMetadata().keySet()) {
                if (metadata.length() > 0) {
                    metadata = metadata + ",";
                }
                metadata = metadata + key + "=" + (String)jiv.getMetadata().get(key);
            }
            boolean simpleName = this.simpleDataName(jiv.getName(), jiv.getValues());
            for (JasmineSingleResult jsr : jiv.getValues()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append(jsr.getTimestamp());
                buffer.append(";");
                buffer.append(this.dateformat.format(jsr.getTimestamp()));
                buffer.append(";");
                String name = null;
                name = simpleName ? jiv.getName() : this.composeName(name, jsr.getName());
                buffer.append(name);
                buffer.append(";");
                buffer.append(jsr.getValue());
                buffer.append(";");
                String metaAndProps = metadata;
                for (String prop : jsr.getProperties().keySet()) {
                    if (metaAndProps.length() > 0) {
                        metaAndProps = metaAndProps + ",";
                    }
                    metaAndProps = metaAndProps + prop + "=" + (String)jsr.getProperties().get(prop);
                }
                buffer.append(metaAndProps);
                this.pw.println(buffer.toString());
            }
        }
    }
}

