/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.outers.file.internal;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.ow2.jasmine.probe.JasmineIndicatorValue;
import org.ow2.jasmine.probe.JasmineOutput;
import org.ow2.jasmine.probe.JasmineProbeResult;
import org.ow2.jasmine.probe.JasmineSingleResult;
import org.ow2.jasmine.probe.outers.JOuter;

public class JFileOuter
extends JOuter {
    private String path = null;
    private PrintWriter pw = null;

    public JFileOuter(JasmineOutput output) {
        super(output);
        Map props = output.getProperties();
        this.path = (String)props.get("path");
        File f = new File(this.path);
        try {
            this.pw = new PrintWriter((Writer)new FileWriter(f), true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void flushData() {
        this.pw.flush();
    }

    public void processData(JasmineProbeResult result) {
        for (JasmineIndicatorValue jiv : result.getValues()) {
            HashMap metadata = jiv.getMetadata();
            String domain = (String)metadata.get("domain");
            String server = (String)metadata.get("server");
            String target = jiv.getTarget();
            this.logger.debug((Object)("domain=" + domain + " server=" + server + " target=" + target), new Object[0]);
            for (JasmineSingleResult jsr : jiv.getValues()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append(jsr.getTimestamp());
                buffer.append(";");
                buffer.append(this.dateformat.format(jsr.getTimestamp()));
                buffer.append(";");
                buffer.append(target);
                buffer.append(";");
                buffer.append(domain);
                buffer.append(";");
                buffer.append(server);
                buffer.append(";");
                buffer.append(this.findMbean(jsr) + ":" + this.composeName(jiv, jsr.getName()));
                buffer.append(";");
                buffer.append(jsr.getValue());
                this.pw.println(buffer.toString());
            }
        }
    }
}

