/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.outers.mule.internal;

import java.util.HashMap;
import java.util.Map;
import org.mule.extras.client.MuleClient;
import org.mule.umo.UMOException;
import org.ow2.jasmine.probe.JasmineIndicValue;
import org.ow2.jasmine.probe.JasmineOutput;
import org.ow2.jasmine.probe.JasmineProbeResult;
import org.ow2.jasmine.probe.JasmineSingleResult;
import org.ow2.jasmine.probe.outers.JOuter;

public class JMuleOuter
extends JOuter {
    private MuleClient client = null;
    private String jasmineURI = "vm://MBeanCmd_dispatcher";
    private String header = "mbeancmd_values_v1\ncmdid;time;domain;server;sname;mbean;";

    public JMuleOuter(JasmineOutput output) {
        super(output);
        Map props = output.getProperties();
    }

    public void processData(JasmineProbeResult result) {
        this.logger.debug((Object)"", new Object[0]);
        if (this.client == null) {
            try {
                this.client = new MuleClient();
            }
            catch (UMOException e) {
                this.logger.error((Object)("Cannot create MuleClient:" + (Object)((Object)e)), new Object[0]);
                return;
            }
        }
        for (JasmineIndicValue jiv : result.getValues()) {
            HashMap metadata = jiv.getMetadata();
            String domain = (String)metadata.get("domain");
            String server = (String)metadata.get("server");
            String target = (String)metadata.get("target");
            for (JasmineSingleResult jsr : jiv.getValues()) {
                HashMap props = jsr.getProperties();
                StringBuilder sb = new StringBuilder(this.header);
                sb.append(jsr.getName());
                sb.append(";\n");
                sb.append(result.getProbeId());
                sb.append(";");
                sb.append(jsr.getTimestamp());
                sb.append(";");
                sb.append(domain);
                sb.append(";");
                sb.append(server);
                sb.append(";");
                sb.append(target);
                sb.append(";");
                String mbean = (String)props.get("mbean");
                sb.append(mbean);
                sb.append(";");
                sb.append(jsr.getValue());
                sb.append("\n");
                try {
                    this.client.dispatch(this.jasmineURI, (Object)sb.toString(), null);
                }
                catch (UMOException e) {
                    this.logger.error((Object)("Cannot dispatch to MuleClient:" + (Object)((Object)e)), new Object[0]);
                    return;
                }
            }
        }
    }
}

