/**
 * JASMINe
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: MuleOuterService.java 8780 2011-09-01 06:30:00Z durieuxp $
 * --------------------------------------------------------------------------
 */

package org.ow2.jasmine.probe.outers.mule.internal;

import org.apache.felix.ipojo.annotations.*;
import org.ow2.jasmine.probe.JasmineOutput;
import org.ow2.jasmine.probe.JasminePropertyInfo;
import org.ow2.jasmine.probe.outer.JasmineOuter;
import org.ow2.jasmine.probe.outer.JasmineOuterException;
import org.ow2.jasmine.probe.outer.JasmineOuterService;
import org.ow2.jasmine.probe.outers.JOuter;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Manages a list of JOuter objects (in fact JMuleOuter instances).
 * @author durieuxp
 */
@Component(name="MuleOuterService")
@Provides
public class MuleOuterService implements JasmineOuterService {

    /**
     * Logger.
     */
    protected Log logger = LogFactory.getLog(JOuter.class);

    /**
     * List of Outer
     */
    private Map<String, JOuter> outerList = new HashMap<String, JOuter>();

    @ServiceProperty(name="output.type", value="mule")
    private String outputType;

    /**
     * Info about Properties
     */
    private List<JasminePropertyInfo> properties;

    @Validate
    public void start() {
        // init the list of properties
        properties = new ArrayList<JasminePropertyInfo>();
        properties.add(new JasminePropertyInfo("url", "URL of the eventswitch", false));
    }

    @Invalidate
    public void stop() {
    }

    // --------------------------------------------------------------------------------
    //  JasmineOuterService implementation
    // --------------------------------------------------------------------------------

    /**
     * Create an Outer for this JasmineOutput
     * @param jasmineOutput
     * @return the Outer
     * @throws org.ow2.jasmine.probe.outer.JasmineOuterException operation failed
     */
    public synchronized JasmineOuter getOuter(JasmineOutput jasmineOutput) throws JasmineOuterException {
        String name = jasmineOutput.getName();
        JOuter outer = outerList.get(name);
        if (outer == null) {
            if (! jasmineOutput.getType().equals(outputType)) {
                logger.error("Bad type: " + jasmineOutput.getType());
                throw new JasmineOuterException("Bad type: " + jasmineOutput.getType());
            }
            outer = new JMuleOuter(jasmineOutput);
            outerList.put(name, outer);
            outer.start();
        }
        return outer;
    }

    /**
     * Retrieve the description of all specific properties hidden in JasmineOutput
     * Return a Map of all properties with their description
     * @return  a Map of property descriptions
     */
    public List<JasminePropertyInfo> getPropertiesInfo() {
        return properties;
    }

}
