/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.outers.mule.internal;

import java.util.HashMap;
import java.util.Map;
import org.mule.extras.client.MuleClient;
import org.ow2.jasmine.probe.JasmineIndicatorValue;
import org.ow2.jasmine.probe.JasmineOutput;
import org.ow2.jasmine.probe.JasmineProbeResult;
import org.ow2.jasmine.probe.JasmineSingleResult;
import org.ow2.jasmine.probe.outers.JOuter;

public class JMuleOuter
extends JOuter {
    private MuleClient client = null;
    private String jasmineURI;
    private String header = "mbeancmd_values_v1\ncmdid;time;domain;server;sname;mbean;";

    public JMuleOuter(JasmineOutput output) {
        super(output);
        Map props = output.getProperties();
        this.jasmineURI = (String)props.get("url");
        if (this.jasmineURI == null) {
            this.jasmineURI = "vm://MBeanCmd_dispatcher";
        }
    }

    public void processData(JasmineProbeResult result) {
        this.logger.debug((Object)"", new Object[0]);
        if (this.client == null) {
            try {
                this.client = new MuleClient();
            }
            catch (Exception e) {
                this.logger.error((Object)("Cannot create MuleClient:" + e), new Object[0]);
                return;
            }
        }
        for (JasmineIndicatorValue jiv : result.getValues()) {
            HashMap metadata = jiv.getMetadata();
            String domain = (String)metadata.get("domain");
            String server = (String)metadata.get("server");
            String target = jiv.getTarget();
            this.logger.debug((Object)("domain=" + domain + " server=" + server + " target=" + target), new Object[0]);
            String indicatorName = jiv.getName();
            boolean simpleName = this.simpleDataName(indicatorName, jiv.getValues());
            for (JasmineSingleResult jsr : jiv.getValues()) {
                StringBuilder sb = new StringBuilder(this.header);
                String name = null;
                name = simpleName ? indicatorName : this.composeName(indicatorName, jsr.getName());
                sb.append(name);
                sb.append(";\n");
                sb.append(result.getProbeId());
                sb.append(";");
                sb.append(jsr.getTimestamp());
                sb.append(";");
                sb.append(domain);
                sb.append(";");
                sb.append(server);
                sb.append(";");
                sb.append(target);
                sb.append(";");
                String mbean = null;
                HashMap resultProps = jsr.getProperties();
                if (!resultProps.isEmpty()) {
                    for (String key : resultProps.keySet()) {
                        if (!"mbean".equals(key)) continue;
                        mbean = (String)resultProps.get(key);
                    }
                }
                sb.append(mbean);
                sb.append(";");
                sb.append(jsr.getValue());
                sb.append("\n");
                try {
                    this.client.dispatch(this.jasmineURI, sb.toString(), null);
                }
                catch (Exception e) {
                    this.logger.error((Object)("Cannot dispatch to MuleClient:" + e), new Object[0]);
                    return;
                }
            }
        }
    }
}

