/**
 * JASMINe
 * Copyright (C) 2011-2012 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: JMuleOuter.java 9751 2012-02-03 11:04:20Z danesa $
 * --------------------------------------------------------------------------
 */

package org.ow2.jasmine.probe.outers.mule.internal;

import java.util.Map;

import org.mule.extras.client.MuleClient;
import org.ow2.jasmine.probe.JasmineIndicatorValue;
import org.ow2.jasmine.probe.JasmineOutput;
import org.ow2.jasmine.probe.JasmineProbeResult;
import org.ow2.jasmine.probe.JasmineSingleResult;
import org.ow2.jasmine.probe.outers.JOuter;

/**
 * Outer implementation for mule.
 * @author durieuxp
 */
public class JMuleOuter extends JOuter {

    private MuleClient client = null;

    private String jasmineURI;
    private String header = "jprobe_values_v1\ncmdid;time;domain;server;sname;mbean;";

    /**
     * Constructor
     * @param output definition
     */
    public JMuleOuter(JasmineOutput output) {
        super(output);
        // specific part of JasmineOutput (property list)
        Map<String, String> props = output.getProperties();
        jasmineURI = props.get("url");
        if (jasmineURI == null) {
            // default is local eventswitch
            jasmineURI = "vm://JProbe_dispatcher";
        }
    }

    /**
     * Publish data on this Output
     * @param result data to publish
     */
    public void processData(JasmineProbeResult result) {
        logger.debug("");
        if (client == null) {
            try {
                client = new MuleClient();
            } catch (Exception e) {
                // Should be UMOException
                logger.error("Cannot create MuleClient:" + e);
                return;
            }
        }
        // We must use the OLD format, defined in Eventswitch here.
        // See eventswitch-config.xml
        // In this version, we have decided to send each attribute separately.
        // LATER: Change this format.
        for (JasmineIndicatorValue jiv : result.getValues()) {
            // Get Metadata
            Map<String, String> metadata = jiv.getMetadata();
            // see JmxCollectorService.META_DOMAIN
            String domain = metadata.get("domain");
            // see JmxCollectorService.META_SERVER
            String server = metadata.get("server");
            String target = jiv.getTarget();
            logger.debug("domain="+domain+" server="+server+" target="+target);
            for (JasmineSingleResult jsr : jiv.getValues()) {
                StringBuilder sb = new StringBuilder(header);
                // end the header with the JSR's name, then pass to new line for printing out values
                sb.append(composeName(jiv, jsr.getName()));
                sb.append(";\n");
                sb.append(result.getProbeId());
                sb.append(SEPARATOR);
                sb.append(jsr.getTimestamp());
                sb.append(SEPARATOR);
                sb.append(domain);
                sb.append(SEPARATOR);
                sb.append(server);
                sb.append(SEPARATOR);
                sb.append(target);
                sb.append(SEPARATOR);
                sb.append(findMbean(jsr));
                sb.append(SEPARATOR);
                sb.append(jsr.getValue());
                sb.append("\n");
                try {
                    client.dispatch(jasmineURI, sb.toString(), null);
                } catch (Exception e) {
                    // Should be UMOException
                    logger.error("Cannot dispatch to MuleClient:" + e);
                    return;
                }
            }
        }
    }

}
