/*
 * Decompiled with CFR 0.152.
 */
package com.conwet.silbops.model;

import com.conwet.silbops.model.OperatorType;
import com.conwet.silbops.model.ValueType;
import com.conwet.silbops.util.JSONUtil;
import com.conwet.silbops.util.JSONizable;
import org.json.simple.JSONArray;

public class Value
implements JSONizable {
    private final ValueType type;
    private final String stringValue;
    private final Long integerValue;
    private final Double floatValue;

    public Value(String value) {
        this.type = ValueType.StringType;
        this.stringValue = value;
        this.integerValue = null;
        this.floatValue = null;
    }

    public Value(Long value) {
        this.type = ValueType.IntegerType;
        this.stringValue = null;
        this.integerValue = value;
        this.floatValue = null;
    }

    public Value(Double value) {
        this.type = ValueType.FloatType;
        this.stringValue = null;
        this.integerValue = null;
        this.floatValue = value;
    }

    public Double getFloat() {
        assert (this.type == ValueType.FloatType);
        return this.floatValue;
    }

    public Long getInteger() {
        assert (this.type == ValueType.IntegerType);
        return this.integerValue;
    }

    public String getString() {
        assert (this.type == ValueType.StringType);
        return this.stringValue;
    }

    public Object getValue() {
        switch (this.type) {
            case StringType: {
                return this.stringValue;
            }
            case IntegerType: {
                return this.integerValue;
            }
            case FloatType: {
                return this.floatValue;
            }
        }
        throw new IllegalStateException("Unexpected type");
    }

    public ValueType getType() {
        return this.type;
    }

    public boolean compare(OperatorType op, Value right) {
        if (this.type != right.type) {
            return false;
        }
        switch (this.type) {
            case StringType: {
                return Value.compareString(this.stringValue, op, right.stringValue);
            }
            case IntegerType: {
                return Value.compareInteger(this.integerValue, op, right.integerValue);
            }
            case FloatType: {
                return Value.compareFloat(this.floatValue, op, right.floatValue);
            }
        }
        throw new IllegalStateException("Unexpected type");
    }

    public static Value fromObject(Object value) {
        if (value instanceof String) {
            return new Value((String)value);
        }
        if (value instanceof Long) {
            return new Value((Long)value);
        }
        if (value instanceof Double) {
            return new Value((Double)value);
        }
        throw new IllegalArgumentException("Invalid type: " + value.getClass().getCanonicalName());
    }

    public static Value fromJSON(JSONArray json) {
        if (json.get(0) instanceof String) {
            ValueType type = ValueType.fromJSON((String)json.get(0));
            switch (type) {
                case FloatType: {
                    return new Value(JSONUtil.unboxFloat(json.get(1)));
                }
                case IntegerType: {
                    return new Value(JSONUtil.unboxInteger(json.get(1)));
                }
                case StringType: {
                    return new Value((String)json.get(1));
                }
            }
            throw new IllegalArgumentException("Malformed object");
        }
        throw new IllegalArgumentException("Malformed object");
    }

    private static boolean compareString(String left, OperatorType op, String right) {
        switch (op) {
            case Eq: {
                return left.equals(right);
            }
            case Ne: {
                return !left.equals(right);
            }
            case Gt: {
                return left.compareTo(right) > 0;
            }
            case Ge: {
                return left.compareTo(right) >= 0;
            }
            case Lt: {
                return left.compareTo(right) < 0;
            }
            case Le: {
                return left.compareTo(right) <= 0;
            }
            case Prefix: {
                return left.indexOf(right) == 0;
            }
            case Suffix: {
                return left.lastIndexOf(right) == left.length() - right.length();
            }
            case Contains: {
                return left.indexOf(right) >= 0;
            }
        }
        throw new IllegalStateException("Unhandled operator");
    }

    private static boolean compareInteger(Long left, OperatorType op, Long right) {
        switch (op) {
            case Eq: {
                return left.equals(right);
            }
            case Ne: {
                return !left.equals(right);
            }
            case Gt: {
                return left > right;
            }
            case Ge: {
                return left >= right;
            }
            case Lt: {
                return left < right;
            }
            case Le: {
                return left <= right;
            }
            case Prefix: 
            case Suffix: 
            case Contains: {
                return false;
            }
        }
        throw new IllegalStateException("Unhandled operator");
    }

    private static boolean compareFloat(Double left, OperatorType op, Double right) {
        switch (op) {
            case Eq: {
                return left.equals(right);
            }
            case Ne: {
                return !left.equals(right);
            }
            case Gt: {
                return left > right;
            }
            case Ge: {
                return left >= right;
            }
            case Lt: {
                return left < right;
            }
            case Le: {
                return left <= right;
            }
            case Prefix: 
            case Suffix: 
            case Contains: {
                return false;
            }
        }
        throw new IllegalStateException("Unhandled operator");
    }

    public String toString() {
        switch (this.type) {
            case StringType: {
                return "\"" + this.stringValue.replaceAll("\"", "\\\"") + "\"";
            }
            case IntegerType: {
                return this.integerValue.toString();
            }
            case FloatType: {
                return this.floatValue.toString() + "D";
            }
        }
        throw new IllegalStateException("Unexpected value type");
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Value other = (Value)obj;
        if (this.type != other.type) {
            return false;
        }
        switch (this.type) {
            case StringType: {
                return this.stringValue.equals(other.stringValue);
            }
            case IntegerType: {
                return this.integerValue.equals(other.integerValue);
            }
            case FloatType: {
                return this.floatValue.equals(other.floatValue);
            }
        }
        throw new IllegalStateException("Unexpected value type");
    }

    public int hashCode() {
        int hash = 3;
        hash = 83 * hash + (this.type != null ? this.type.hashCode() : 0);
        hash = 83 * hash + (this.stringValue != null ? this.stringValue.hashCode() : 0);
        hash = 83 * hash + (this.integerValue != null ? this.integerValue.hashCode() : 0);
        hash = 83 * hash + (this.floatValue != null ? this.floatValue.hashCode() : 0);
        return hash;
    }

    @Override
    public String toJSONString() {
        return this.toJSON().toJSONString();
    }

    @Override
    public JSONArray toJSON() {
        JSONArray result = new JSONArray();
        result.add(this.type.toJSON());
        switch (this.type) {
            case IntegerType: {
                result.add(this.integerValue);
                break;
            }
            case FloatType: {
                result.add(this.floatValue);
                break;
            }
            case StringType: {
                result.add(this.stringValue);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid value type");
            }
        }
        return result;
    }
}

