/*
 * Decompiled with CFR 0.152.
 */
package com.conwet.xjsp;

import com.conwet.xjsp.features.FeatureMap;
import com.conwet.xjsp.features.Session;
import com.conwet.xjsp.session.ClientNegotiationState;
import com.conwet.xjsp.session.ClosingState;
import com.conwet.xjsp.session.ConnectionContext;
import com.conwet.xjsp.textstream.TextClient;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.SynchronousQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class XJSPClient
implements Session {
    private static final Logger logger = LoggerFactory.getLogger(XJSPClient.class);
    private final TextClient client;
    private final FeatureMap features;
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private final ConnectionContext handler;
    private final SynchronousQueue closing;

    XJSPClient(FeatureMap features, String hostname, int port) throws IOException {
        this.features = features;
        ClientNegotiationState initialState = new ClientNegotiationState(this.features);
        this.handler = new ConnectionContext(initialState){

            @Override
            public void dispose() {
                super.dispose();
                try {
                    XJSPClient.this.closing.put(new Object());
                }
                catch (InterruptedException ex) {
                    logger.error("Unexpected exception", ex);
                }
            }
        };
        this.closing = new SynchronousQueue();
        this.client = new TextClient(this.handler, hostname, port);
        this.client.connect();
    }

    @Override
    public Object getAttribute(String attribute) {
        return this.attributes.get(attribute);
    }

    @Override
    public void setAttribute(String attribute, Object value) {
        this.attributes.put(attribute, value);
    }

    @Override
    public void removeAttribute(String attribute) {
        this.attributes.remove(attribute);
    }

    @Override
    public void close() throws IOException {
        this.handler.setState(new ClosingState());
        try {
            this.closing.take();
            this.client.disconnect();
        }
        catch (InterruptedException ex) {
            logger.error("Unexpected exception", ex);
        }
    }

    @Override
    public void sendErrorMessage(int errorCode, String errorMessage) throws IOException {
        this.sendErrorMessage(errorCode, errorMessage, null);
    }

    @Override
    public void sendErrorMessage(int errorCode, String errorMessage, String sourceId) throws IOException {
        this.handler.getChannel().sendErrorMessage(errorCode, errorMessage, sourceId);
    }

    @Override
    public void sendMessage(String feature, String type, Object payload) throws IOException {
        this.handler.getChannel().sendMessage(feature, type, payload, this.features);
    }
}

