/*
 * Decompiled with CFR 0.152.
 */
package com.conwet.xjsp.features;

import com.conwet.xjsp.features.FeatureMap;
import com.conwet.xjsp.features.ImmutableMessage;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageChannel {
    private static final Logger logger = LoggerFactory.getLogger(MessageChannel.class);
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private final SocketChannel channel;
    private long lastId;

    public MessageChannel(SocketChannel channel) {
        this.channel = channel;
        this.lastId = 0L;
    }

    public synchronized void sendFragment(String fragment) {
        ByteBuffer buffer = ByteBuffer.wrap(fragment.getBytes(UTF8));
        try {
            while (buffer.hasRemaining()) {
                this.channel.write(buffer);
            }
        }
        catch (IOException ex) {
            logger.error("Closing connection on exception", ex);
        }
    }

    public synchronized void sendMessage(String feature, String type, Object payload, FeatureMap fm) {
        ImmutableMessage message = new ImmutableMessage(feature, type, payload, this.nextId());
        this.sendFragment(message.toJSONObject(fm).toJSONString());
    }

    public synchronized void sendErrorMessage(Object payload) {
        JSONObject message = new JSONObject();
        message.put("id", this.nextId());
        message.put("type", "xjsp:error");
        message.put("message", payload);
        this.sendFragment(message.toJSONString());
    }

    public synchronized void sendErrorMessage(int errorCode, String errorMessage, String sourceId) {
        JSONObject payload = new JSONObject();
        payload.put("code", errorCode);
        payload.put("message", errorMessage);
        payload.put("id", sourceId);
        this.sendErrorMessage(payload);
    }

    public synchronized void close() {
        try {
            this.channel.close();
        }
        catch (IOException ex) {
            logger.error("Unexpected exception", ex);
        }
    }

    private String nextId() {
        return Long.toString(++this.lastId);
    }
}

