/*
 * Decompiled with CFR 0.152.
 */
package com.conwet.xjsp.session;

import com.conwet.xjsp.errors.ConnError;
import com.conwet.xjsp.errors.ConnectionException;
import com.conwet.xjsp.features.FeatureMap;
import com.conwet.xjsp.json.JSONUtil;
import com.conwet.xjsp.session.ConnectionContext;
import com.conwet.xjsp.session.ConnectionState;
import com.conwet.xjsp.session.NegotiationPhase;
import com.conwet.xjsp.session.SessionState;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientNegotiationState
implements ConnectionState {
    static final Pattern START_PATTERN = Pattern.compile("^\\s*\\{\\s*\"header\"\\s*:\\s*");
    static final Pattern MESSAGE_PATTERN = Pattern.compile("^\\s*,\\s*\"messages\"\\s*:\\s*\\[\\s*");
    private static final String OPENING_FRAGMENT = "{\n\"header\": {\"protocol\": \"xjsp\", \"version\" : \"1.0\", \"features\": [%s]},\n\"messages\":[";
    private static final Logger logger = LoggerFactory.getLogger(ClientNegotiationState.class);
    private final JSONParser parser;
    private final FeatureMap prefixes;
    private NegotiationPhase phase = NegotiationPhase.start;

    public ClientNegotiationState(FeatureMap prefixes) {
        this.parser = new JSONParser();
        this.prefixes = prefixes;
    }

    @Override
    public void start(ConnectionContext context) throws ConnectionException {
        StringBuilder features = new StringBuilder();
        for (String prefix : this.prefixes.getAllPrefixes()) {
            if (features.length() > 0) {
                features.append(", ");
            }
            features.append("\"").append(prefix).append("=").append(this.prefixes.resolveFeature(prefix).getFeatureName()).append("\"");
        }
        context.getChannel().sendFragment(String.format(OPENING_FRAGMENT, features.toString()));
    }

    @Override
    public void newData(ConnectionContext context) throws ConnectionException {
        NegotiationPhase newPhase;
        while ((newPhase = this.consumeData(context.getBuffer())) != null) {
            this.phase = newPhase;
        }
        if (this.phase == NegotiationPhase.finished) {
            context.setState(new SessionState(this.prefixes));
        }
    }

    @Override
    public long getTimeoutPeriod(ConnectionContext context) {
        return 10000L;
    }

    @Override
    public void timeout(ConnectionContext context) throws ConnectionException {
        logger.error("Expired timeout in negotiation");
        context.getChannel().close();
    }

    private NegotiationPhase consumeData(StringBuilder buffer) throws ConnectionException {
        switch (this.phase) {
            case start: {
                Matcher m = START_PATTERN.matcher(buffer);
                if (m.find()) {
                    buffer.replace(0, m.end(), "");
                    return NegotiationPhase.header;
                }
                return null;
            }
            case header: {
                try {
                    String header = JSONUtil.extractStanza(buffer);
                    if (header == null) {
                        return null;
                    }
                    JSONObject jsonHeader = (JSONObject)this.parser.parse(header);
                    this.validateHeader(jsonHeader);
                    return NegotiationPhase.messages;
                }
                catch (ParseException ex) {
                    throw new ConnectionException(ConnError.ProtocolSyntaxError, "Invalid header: " + ex.getMessage());
                }
            }
            case messages: {
                Matcher m = MESSAGE_PATTERN.matcher(buffer);
                if (m.find()) {
                    buffer.replace(0, m.end(), "");
                    return NegotiationPhase.finished;
                }
                return null;
            }
            case finished: {
                return null;
            }
        }
        throw new IllegalStateException("Unexpected exception");
    }

    private void validateHeader(JSONObject jsonHeader) throws ConnectionException {
        try {
            String protocol = (String)jsonHeader.get("protocol");
        }
        catch (NullPointerException ex) {
            throw new ConnectionException(ConnError.NegotiationFieldError, "header.protocol");
        }
        try {
            String version = (String)jsonHeader.get("version");
        }
        catch (NullPointerException ex) {
            throw new ConnectionException(ConnError.NegotiationFieldError, "header.version");
        }
    }
}

