/*
 * Decompiled with CFR 0.152.
 */
package com.conwet.xjsp.features;

import com.conwet.xjsp.features.FeatureMap;
import com.conwet.xjsp.features.Message;
import org.json.simple.JSONObject;

public class ImmutableMessage
implements Message {
    private final String id;
    private final String messageType;
    private final String feature;
    private final Object payload;

    public ImmutableMessage(String feature, String messageType, Object payload, String id) {
        this.id = id;
        this.messageType = messageType;
        this.payload = payload;
        this.feature = feature;
    }

    @Override
    public String getFeature() {
        return this.feature;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getMessageType() {
        return this.messageType;
    }

    @Override
    public Object getPayload() {
        return this.payload;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImmutableMessage other = (ImmutableMessage)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.messageType == null ? other.messageType != null : !this.messageType.equals(other.messageType)) {
            return false;
        }
        if (this.feature == null ? other.feature != null : !this.feature.equals(other.feature)) {
            return false;
        }
        return this.payload == other.payload || this.payload != null && this.payload.equals(other.payload);
    }

    public int hashCode() {
        int hash = 3;
        hash = 41 * hash + (this.id != null ? this.id.hashCode() : 0);
        hash = 41 * hash + (this.messageType != null ? this.messageType.hashCode() : 0);
        hash = 41 * hash + (this.feature != null ? this.feature.hashCode() : 0);
        hash = 41 * hash + (this.payload != null ? this.payload.hashCode() : 0);
        return hash;
    }

    public String toString() {
        return "InmutableMessage{id=" + this.id + ", messageType=" + this.messageType + ", feature=" + this.feature + ", payload=" + this.payload + '}';
    }

    @Override
    public JSONObject toJSONObject(FeatureMap fm) {
        JSONObject object = new JSONObject();
        object.put("id", this.id);
        object.put("type", fm.getPrefix(this.getFeature()) + ":" + this.messageType);
        object.put("message", this.payload);
        return object;
    }
}

