/*
 * Decompiled with CFR 0.152.
 */
package com.conwet.xjsp.session;

import com.conwet.xjsp.errors.ConnectionException;
import com.conwet.xjsp.features.MessageChannel;
import com.conwet.xjsp.features.SessionListener;
import com.conwet.xjsp.session.ConnectionState;
import com.conwet.xjsp.textstream.ConnectionHandler;
import java.nio.channels.SocketChannel;
import java.util.LinkedList;
import java.util.List;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionContext
implements ConnectionHandler {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionContext.class);
    private final ConnectionState initialState;
    private ConnectionState state;
    private MessageChannel channel;
    private final StringBuilder buffer;
    private final List<SessionListener> sessionListeners;

    public ConnectionContext(ConnectionState initialState) {
        this(initialState, new LinkedList<SessionListener>());
    }

    public ConnectionContext(ConnectionState initialState, List<SessionListener> sessionListeners) {
        this.initialState = initialState;
        this.sessionListeners = sessionListeners;
        this.state = null;
        this.buffer = new StringBuilder();
    }

    @Override
    public void start() {
        this.setState(this.initialState);
    }

    public void setState(ConnectionState state) {
        this.state = state;
        try {
            this.state.start(this);
        }
        catch (ConnectionException ex) {
            this.handleConnectionException(ex);
        }
    }

    @Override
    public void newData(String data) {
        this.buffer.append(data);
        try {
            this.state.newData(this);
        }
        catch (ConnectionException ex) {
            this.handleConnectionException(ex);
        }
    }

    @Override
    public void setChannel(SocketChannel channel) {
        this.channel = new MessageChannel(channel);
    }

    public StringBuilder getBuffer() {
        return this.buffer;
    }

    public MessageChannel getChannel() {
        return this.channel;
    }

    public List<SessionListener> getSessionListeners() {
        return this.sessionListeners;
    }

    @Override
    public void dispose() {
        this.channel.close();
    }

    @Override
    public void timeout() {
        try {
            this.state.timeout(this);
        }
        catch (ConnectionException ex) {
            this.handleConnectionException(ex);
        }
    }

    @Override
    public long getTimeoutPeriod() {
        return this.state.getTimeoutPeriod(this);
    }

    private void handleConnectionException(ConnectionException ex) {
        switch (ex.getError()) {
            case ProtocolSyntaxError: 
            case NegotiationError: 
            case NegotiationFieldError: 
            case NegotiationTimeout: {
                logger.error("Closing connection on error: {}", (Object)ex.getError());
                this.dispose();
                break;
            }
            default: {
                JSONObject payload = new JSONObject();
                payload.put("code", ex.getErrorCode());
                payload.put("message", ex.getMessage());
                if (ex.getMessageId() != null) {
                    payload.put("id", ex.getMessageId());
                }
                this.channel.sendErrorMessage(payload);
            }
        }
    }
}

