/**
 * JASMINe
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: SilbopsOuterService.java 8990 2011-09-26 09:09:31Z pelletib $
 * --------------------------------------------------------------------------
 */

package org.ow2.jasmine.probe.outers.silbops.internal;

import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Invalidate;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.ServiceProperty;
import org.apache.felix.ipojo.annotations.Validate;
import org.ow2.jasmine.probe.JasmineOutput;
import org.ow2.jasmine.probe.JasminePropertyInfo;
import org.ow2.jasmine.probe.outer.JasmineOuter;
import org.ow2.jasmine.probe.outer.JasmineOuterException;
import org.ow2.jasmine.probe.outers.JOuter;
import org.ow2.jasmine.probe.outers.JOuterService;

import java.util.ArrayList;
import java.util.List;
/**
 * Manages a list of JOuter objects (in fact JSilbopsOuter instances).
 * @author durieuxp
 */
@Component(name="SilbopsOuterService")
@Provides
public class SilbopsOuterService extends JOuterService {

    @ServiceProperty(name="output.type", value="silbops")
    private String outputType;

    @Validate
    public void start() {
        // init the list of properties
        properties = new ArrayList<JasminePropertyInfo>();
	System.out.println("SilbopsOuterService started");
        // TODO
    }

    @Invalidate
    public void stop() {
    }

    // --------------------------------------------------------------------------------
    //  JasmineOuterService implementation
    // --------------------------------------------------------------------------------

    /**
     * Create an Outer for this JasmineOutput
     * @param jasmineOutput
     * @return the Outer
     * @throws org.ow2.jasmine.probe.outer.JasmineOuterException operation failed
     */
    public synchronized JasmineOuter getOuter(JasmineOutput jasmineOutput) throws JasmineOuterException {
        String name = jasmineOutput.getName();
        JOuter outer = outerList.get(name);
	System.out.println("SilbopsOuterService to start");
        if (outer == null) {
            outer = new JSilbopsOuter(jasmineOutput);
            outerList.put(name, outer);
            outer.start();
        }
        return outer;
    }

}
