/*
 * Decompiled with CFR 0.152.
 */
package com.conwet.silbops.api;

import com.conwet.silbops.api.IConnectionFactory;
import java.lang.reflect.Constructor;
import java.net.URI;

public class ConnectionFactory {
    private static Class<? extends IConnectionFactory> clazz = null;

    public static IConnectionFactory createFactory(URI brokerURL) {
        if (clazz == null) {
            ConnectionFactory.resolveConnectionFactoryClass();
        }
        try {
            Constructor<? extends IConnectionFactory> constructor = clazz.getConstructor(URI.class);
            return constructor.newInstance(brokerURL);
        }
        catch (Exception ex) {
            throw new RuntimeException("Cannot instantiate SilboPS API implementation, check the classpath", ex);
        }
    }

    private static void resolveConnectionFactoryClass() {
        try {
            Class<?> implClass = Class.forName("com.conwet.silbops.api.impl.ConnectionFactoryImpl");
            clazz = implClass.asSubclass(IConnectionFactory.class);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException("Cannot find SilboPS API implementation, check the classpath", ex);
        }
        catch (ClassCastException ex) {
            throw new RuntimeException("Cannot find a valid SilboPS API implementation that implements IConnectionFactory", ex);
        }
    }
}

