/*
 * Decompiled with CFR 0.152.
 */
package com.conwet.silbops.model;

import com.conwet.silbops.model.Value;
import com.conwet.silbops.model.ValueType;
import com.conwet.silbops.util.JSONUtil;
import com.conwet.silbops.util.JSONizable;
import com.conwet.silbops.util.MultiValueMap;
import java.util.Collection;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class Notification
implements JSONizable {
    private final MultiValueMap<String, Value> attributes = new MultiValueMap();

    public Notification attribute(String name, Object value) {
        this.attributes.add(name, Value.fromObject(value));
        return this;
    }

    public Collection<Value> getValues(String attributeName) {
        return this.attributes.get(attributeName);
    }

    public String toString() {
        return this.attributes.toString();
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        for (String attribute : this.attributes.keys()) {
            JSONArray valuesJson = new JSONArray();
            for (Value value : this.attributes.get(attribute)) {
                valuesJson.add(value.getType().toJSON());
                valuesJson.add(value.getValue());
            }
            json.put(attribute, valuesJson);
        }
        return json;
    }

    @Override
    public String toJSONString() {
        return this.toJSON().toJSONString();
    }

    public static Notification fromJSON(JSONObject json) {
        Notification notification = new Notification();
        for (Object key : json.keySet()) {
            String attribute = (String)key;
            if (!(json.get(key) instanceof JSONArray)) {
                throw new IllegalArgumentException("Malformed object");
            }
            JSONArray values = (JSONArray)json.get(key);
            int pair = 0;
            while (pair * 2 < values.size()) {
                Object rawValue = values.get(pair * 2 + 1);
                ValueType type = ValueType.fromJSON(JSONUtil.unboxString(values.get(pair * 2)));
                switch (type) {
                    case StringType: {
                        rawValue = JSONUtil.unboxString(rawValue);
                        break;
                    }
                    case FloatType: {
                        rawValue = JSONUtil.unboxFloat(rawValue);
                        break;
                    }
                    case IntegerType: {
                        rawValue = JSONUtil.unboxInteger(rawValue);
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                notification.attribute(attribute, rawValue);
                ++pair;
            }
        }
        return notification;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Notification other = (Notification)obj;
        return this.attributes == other.attributes || this.attributes != null && this.attributes.equals(other.attributes);
    }

    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + (this.attributes != null ? this.attributes.hashCode() : 0);
        return hash;
    }
}

