/*
 * Decompiled with CFR 0.152.
 */
package com.conwet.xjsp.session;

import com.conwet.xjsp.features.FeatureMap;
import com.conwet.xjsp.features.MessageChannel;
import com.conwet.xjsp.features.Session;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractSession
implements Session {
    private final MessageChannel channel;
    private final Map<String, Object> attributes;
    private final FeatureMap features;

    public AbstractSession(MessageChannel channel, FeatureMap features) {
        this.channel = channel;
        this.features = features;
        this.attributes = new HashMap<String, Object>();
    }

    @Override
    public void sendErrorMessage(int errorCode, String errorMessage) throws IOException {
        this.sendErrorMessage(errorCode, errorMessage, null);
    }

    @Override
    public void sendErrorMessage(int errorCode, String errorMessage, String sourceId) throws IOException {
        this.channel.sendErrorMessage(errorCode, errorMessage, sourceId);
    }

    @Override
    public void sendMessage(String feature, String type, Object payload) throws IOException {
        this.channel.sendMessage(feature, type, payload, this.features);
    }

    @Override
    public Object getAttribute(String attribute) {
        return this.attributes.get(attribute);
    }

    @Override
    public void removeAttribute(String attribute) {
        this.attributes.remove(attribute);
    }

    @Override
    public void setAttribute(String attribute, Object value) {
        this.attributes.put(attribute, value);
    }
}

