/*
 * Decompiled with CFR 0.152.
 */
package com.conwet.xjsp.textstream;

import com.conwet.xjsp.textstream.ConnectionHandler;
import com.conwet.xjsp.textstream.TimeoutSelectLoop;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextClient {
    private static final Logger logger = LoggerFactory.getLogger(TextClient.class);
    private final ConnectionHandler handler;
    private final TimeoutSelectLoop loopThread;
    private SocketChannel channel;
    private final Selector selector;
    private final InetSocketAddress address;

    public TextClient(ConnectionHandler handler, String host, int port) throws IOException {
        this.handler = handler;
        this.address = new InetSocketAddress(host, port);
        this.selector = Selector.open();
        this.loopThread = new TimeoutSelectLoop(this.selector, null);
    }

    public void connect() throws IOException {
        this.channel = SocketChannel.open();
        this.channel.connect(this.address);
        this.channel.finishConnect();
        this.loopThread.registerChannel(this.channel, this.handler);
        this.loopThread.start();
    }

    public void disconnect() {
        this.loopThread.stopSelecting();
        try {
            this.loopThread.join();
        }
        catch (InterruptedException ex) {
            logger.error("Unexpected exception", ex);
        }
        try {
            this.selector.close();
            this.channel.close();
        }
        catch (IOException ex) {
            logger.error("Error when closing then connection", ex);
        }
    }
}

