/*
 * Decompiled with CFR 0.152.
 */
package com.conwet.xjsp.textstream;

import com.conwet.xjsp.textstream.ConnectionHandlerFactory;
import com.conwet.xjsp.textstream.TimeoutSelectLoop;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextServer {
    private static final Logger logger = LoggerFactory.getLogger(TextServer.class);
    private final InetSocketAddress address;
    private final TimeoutSelectLoop loopThread;
    private final Selector selector;
    private final ServerSocket serverSocket;
    private final ConnectionHandlerFactory factory;

    public TextServer(String host, int port, ConnectionHandlerFactory factory) throws IOException {
        this.address = new InetSocketAddress(host, port);
        this.factory = factory;
        ServerSocketChannel serverChannel = ServerSocketChannel.open();
        serverChannel.configureBlocking(false);
        this.serverSocket = serverChannel.socket();
        this.serverSocket.setReuseAddress(true);
        this.selector = Selector.open();
        serverChannel.register(this.selector, 16);
        this.loopThread = new TimeoutSelectLoop(this.selector, factory);
    }

    public void start() throws IOException {
        this.serverSocket.bind(this.address);
        this.loopThread.start();
    }

    public void stop() {
        this.loopThread.stopSelecting();
        try {
            this.loopThread.join();
        }
        catch (InterruptedException ex) {
            logger.error("Unexpected exception", ex);
        }
        try {
            this.selector.close();
            this.serverSocket.close();
        }
        catch (IOException ex) {
            logger.error("Error when closing connections", ex);
        }
    }

    protected ConnectionHandlerFactory getConnectionFactory() {
        return this.factory;
    }
}

