/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.outers.silbops.internal;

import com.conwet.silbops.api.ConnectionFactory;
import com.conwet.silbops.api.IConnectionFactory;
import com.conwet.silbops.api.PubEndpoint;
import com.conwet.silbops.model.Notification;
import java.net.URI;
import java.util.Map;
import org.ow2.jasmine.probe.JasmineIndicatorValue;
import org.ow2.jasmine.probe.JasmineOutput;
import org.ow2.jasmine.probe.JasmineProbeResult;
import org.ow2.jasmine.probe.JasmineSingleResult;
import org.ow2.jasmine.probe.outers.JOuter;

public class JSilbopsOuter
extends JOuter {
    private PubEndpoint endpoint = null;
    private URI uri = null;

    public JSilbopsOuter(JasmineOutput output) {
        super(output);
        Map props = output.getProperties();
        String uriStr = (String)props.get("uri");
        this.uri = uriStr != null ? URI.create(uriStr) : URI.create("silbops://pubsub.no-ip.org");
        this.logger.debug((Object)("uri=" + this.uri), new Object[0]);
    }

    public void processData(JasmineProbeResult result) {
        this.logger.debug((Object)("uri=" + this.uri.toString() + " - result=" + result), new Object[0]);
        if (this.endpoint == null && !this.uri.toString().equals("silbops://mock")) {
            IConnectionFactory cf = ConnectionFactory.createFactory(this.uri);
            this.endpoint = cf.openPubEndpoint();
            this.logger.debug((Object)("factory <" + this.uri + "> created"), new Object[0]);
        } else if (this.uri.toString().equals("silbops://mock")) {
            this.logger.debug((Object)("factory MOCK <" + this.uri + "> used for test"), new Object[0]);
        }
        for (JasmineIndicatorValue jiv : result.getValues()) {
            String indicatorName = jiv.getName();
            boolean simpleName = this.simpleDataName(indicatorName, jiv.getValues());
            for (JasmineSingleResult jsr : jiv.getValues()) {
                Notification not = new Notification();
                not.attribute("timestamp", jsr.getTimestamp());
                if (simpleName) {
                    not.attribute("indicator", indicatorName);
                } else {
                    not.attribute("indicator", this.composeName(indicatorName, jsr.getName()));
                }
                if (jsr.getValue() instanceof Integer) {
                    not.attribute("value", ((Integer)jsr.getValue()).longValue());
                } else if (jsr.getValue() instanceof Long) {
                    not.attribute("value", (long)((Long)jsr.getValue()));
                } else if (jsr.getValue() instanceof Float) {
                    not.attribute("value", ((Float)jsr.getValue()).longValue());
                } else {
                    not.attribute("value", jsr.getValue());
                }
                not.attribute("server", jiv.getTarget());
                try {
                    if (this.endpoint != null) {
                        this.endpoint.publish(not);
                        this.logger.debug((Object)("Publish not=" + not), new Object[0]);
                        continue;
                    }
                    this.logger.debug((Object)("not=" + not), new Object[0]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

