/**
 * JASMINe
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: JSilbopsOuter.java 9102 2011-10-07 12:51:28Z pelletib $
 * --------------------------------------------------------------------------
 */

package org.ow2.jasmine.probe.outers.silbops.internal;

import com.conwet.silbops.api.ConnectionFactory;
import com.conwet.silbops.api.IConnectionFactory;
import com.conwet.silbops.api.PubEndpoint;
import com.conwet.silbops.model.Notification;

import org.ow2.jasmine.probe.JasmineIndicatorValue;
import org.ow2.jasmine.probe.JasmineOutput;
import org.ow2.jasmine.probe.JasmineProbeResult;
import org.ow2.jasmine.probe.JasmineSingleResult;
import org.ow2.jasmine.probe.outers.JOuter;

import java.net.URI;
import java.util.Map;

/**
 * Outer implementation for silboPS.
 * @author durieuxp
 */
public class JSilbopsOuter extends JOuter {


    private PubEndpoint endpoint = null;

    private URI uri = null;

    /**
     * Constructor
     * @param output definition
     */
    public JSilbopsOuter(JasmineOutput output) {
        super(output);
        // specific part of JasmineOutput (property list)
        Map<String, String> props = output.getProperties();
	String uriStr = props.get("uri");
	if (uriStr != null) {
           uri = URI.create(uriStr);
        } else {
           uri = URI.create("silbops://pubsub.no-ip.org");           
        }
        logger.debug("uri=" + uri);
    }

    /**
     * Publish data on this Output
     * @param result data to publish
     */
    public void processData(JasmineProbeResult result) {
        logger.debug("uri=" + uri.toString() + " - result=" + result);
        if (endpoint == null && !uri.toString().equals("silbops://mock")) {
            IConnectionFactory cf = ConnectionFactory.createFactory(uri);
            endpoint = cf.openPubEndpoint();
            logger.debug("factory <" + uri + "> created");
        } else if (uri.toString().equals("silbops://mock")) {
            logger.debug("factory MOCK <" + uri + "> used for test");
        }
        for (JasmineIndicatorValue jiv : result.getValues()) {

            String indicatorName = jiv.getName();
            boolean simpleName = simpleDataName(indicatorName, jiv.getValues());
            String domain = "jonas";
            Map<String, String> metadata = jiv.getMetadata();
            for (String key : metadata.keySet()) {
              if ( key.equals("domain") ) {
                 domain = metadata.get(key);
              }
            }

            for (JasmineSingleResult jsr : jiv.getValues()) {
                Notification not = new Notification();

		not.attribute("eventType", "monitoring");
                not.attribute("timestamp", jsr.getTimestamp());

                if (!simpleName) {
                    indicatorName = composeName(indicatorName, jsr.getName());
                }
		String[] fields = indicatorName.split("-");
		
		// indicator is composed of i-<jonasName>-<componentName>-<indicatorName>-<unit>
		String component = "";
		if (fields.length < 5) {
			logger.warn("Invalid indicator name : indicatorName: " +  indicatorName);
			component = "?";
                	not.attribute("measureUnit", "?");
                	not.attribute("measureName", indicatorName);
		} else {
                	component = fields[2];
			String realIndicatorName= fields[3];
			realIndicatorName = realIndicatorName.substring(0,1).toLowerCase()+realIndicatorName.substring(1);
                	not.attribute("measureUnit", fields[4]);
                	not.attribute("measureName", realIndicatorName);
		}

		if (jsr.getValue() instanceof java.lang.Integer) {
	                not.attribute("measureValue", ((Integer)jsr.getValue()).longValue() );
		} else if (jsr.getValue() instanceof java.lang.Long) {
	                not.attribute("measureValue", ((Long)jsr.getValue()).longValue());
		} else if (jsr.getValue() instanceof java.lang.Float) {
	                not.attribute("measureValue",((Float)jsr.getValue()).longValue() );
		} else {
	                not.attribute("measureValue",jsr.getValue() );
		}

		not.attribute("fqn", "/" + domain + "/" + jiv.getTarget() + "/" + component);


		/*
                Map<String, String> metadata = jiv.getMetadata();
                Map<String, String> props = jsr.getProperties();
                for (String key : props.keySet()) {
                    not.attribute(key, props.get(key));
                }
                for (String key : metadata.keySet()) {
                    not.attribute(key, metadata.get(key));
                }
		*/
                try {
                    if (endpoint != null) {
                      endpoint.publish(not);
                      logger.debug("Publish not=" + not);
                    } else {
                      logger.debug("not=" + not);
                    }
		} catch (Exception e) {
			e.printStackTrace();
		}
            }
        }
    }

}
