/*
 * Decompiled with CFR 0.152.
 */
package com.conwet.silbops.model;

import com.conwet.silbops.model.OperatorType;
import com.conwet.silbops.model.Value;
import com.conwet.silbops.util.JSONizable;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class Constraint
implements JSONizable {
    private final OperatorType type;
    private final Value value;

    public Constraint() {
        this(OperatorType.Exists, null);
    }

    public Constraint(OperatorType type, Value value) {
        assert (type.validOperand(value));
        this.type = type;
        this.value = value;
    }

    public OperatorType getType() {
        return this.type;
    }

    public boolean match(Value value) {
        return this.type == OperatorType.Exists || value.compare(this.type, this.value);
    }

    public boolean covers(Constraint other) {
        if (this.type == OperatorType.Exists) {
            return true;
        }
        if (this.value.getType() != other.value.getType()) {
            return false;
        }
        switch (this.type) {
            case Eq: {
                return this.type == other.type && this.value.compare(OperatorType.Eq, other.value);
            }
            case Ne: {
                switch (other.type) {
                    case Eq: {
                        return other.value.compare(OperatorType.Ne, this.value);
                    }
                    case Ne: {
                        return this.value.compare(OperatorType.Eq, other.value);
                    }
                    case Gt: {
                        return other.value.compare(OperatorType.Ge, this.value);
                    }
                    case Ge: {
                        return other.value.compare(OperatorType.Gt, this.value);
                    }
                    case Lt: {
                        return other.value.compare(OperatorType.Le, this.value);
                    }
                    case Le: {
                        return other.value.compare(OperatorType.Lt, this.value);
                    }
                }
                return false;
            }
            case Gt: {
                switch (other.type) {
                    case Gt: {
                        return other.value.compare(OperatorType.Ge, this.value);
                    }
                    case Eq: 
                    case Ge: {
                        return other.value.compare(OperatorType.Gt, this.value);
                    }
                }
                return false;
            }
            case Ge: {
                switch (other.type) {
                    case Eq: 
                    case Gt: 
                    case Ge: {
                        return other.value.compare(OperatorType.Ge, this.value);
                    }
                }
                return false;
            }
            case Lt: {
                switch (other.type) {
                    case Lt: {
                        return other.value.compare(OperatorType.Le, this.value);
                    }
                    case Eq: 
                    case Le: {
                        return other.value.compare(OperatorType.Lt, this.value);
                    }
                }
                return false;
            }
            case Le: {
                switch (other.type) {
                    case Eq: 
                    case Lt: 
                    case Le: {
                        return other.value.compare(OperatorType.Le, this.value);
                    }
                }
                return false;
            }
            case Prefix: 
            case Suffix: 
            case Contains: {
                return this.type == other.type && other.value.compare(this.type, this.value);
            }
        }
        throw new IllegalStateException();
    }

    public String toString() {
        return this.type + " " + this.value;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Constraint other = (Constraint)obj;
        if (this.type != other.type) {
            return false;
        }
        return this.value == other.value || this.value != null && this.value.equals(other.value);
    }

    public int hashCode() {
        int hash = 7;
        hash = 41 * hash + (this.type != null ? this.type.hashCode() : 0);
        hash = 41 * hash + (this.value != null ? this.value.hashCode() : 0);
        return hash;
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        if (this.type != OperatorType.Exists) {
            json.put(this.type.toJSON(), this.value);
        }
        return json;
    }

    @Override
    public String toJSONString() {
        return this.toJSON().toJSONString();
    }

    public static Constraint fromJSON(JSONObject json) {
        if (json.keySet().size() != 1) {
            throw new IllegalArgumentException("Malformed object");
        }
        String type = (String)json.keySet().iterator().next();
        if (json.get(type) instanceof JSONArray) {
            JSONArray value = (JSONArray)json.get(type);
            return new Constraint(OperatorType.fromJSON(type), Value.fromJSON(value));
        }
        throw new IllegalArgumentException("Malformed object");
    }
}

