/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.outers.silbops.internal;

import com.conwet.silbops.api.ConnectionFactory;
import com.conwet.silbops.api.IConnectionFactory;
import com.conwet.silbops.api.PubEndpoint;
import com.conwet.silbops.model.Notification;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.ow2.jasmine.probe.JasmineIndicatorValue;
import org.ow2.jasmine.probe.JasmineOutput;
import org.ow2.jasmine.probe.JasmineProbeResult;
import org.ow2.jasmine.probe.JasmineSingleResult;
import org.ow2.jasmine.probe.outers.JOuter;

public class JSilbopsOuter
extends JOuter {
    private PubEndpoint endpoint = null;
    private URI uri = null;

    public JSilbopsOuter(JasmineOutput output) {
        super(output);
        Map props = output.getProperties();
        String uriStr = (String)props.get("uri");
        this.uri = uriStr != null ? URI.create(uriStr) : URI.create("silbops://pubsub.no-ip.org");
        this.logger.debug((Object)("uri=" + this.uri), new Object[0]);
    }

    public void processData(JasmineProbeResult result) {
        this.logger.debug((Object)("uri=" + this.uri.toString() + " - result=" + result), new Object[0]);
        if (this.endpoint == null && !this.uri.toString().equals("silbops://mock")) {
            IConnectionFactory cf = ConnectionFactory.createFactory(this.uri);
            this.endpoint = cf.openPubEndpoint();
            this.logger.debug((Object)("factory <" + this.uri + "> created"), new Object[0]);
        } else if (this.uri.toString().equals("silbops://mock")) {
            this.logger.debug((Object)("factory MOCK <" + this.uri + "> used for test"), new Object[0]);
        }
        for (JasmineIndicatorValue jiv : result.getValues()) {
            String indicatorName = jiv.getName();
            boolean simpleName = this.simpleDataName(indicatorName, jiv.getValues());
            String domain = "jonas";
            HashMap metadata = jiv.getMetadata();
            for (String key : metadata.keySet()) {
                if (!key.equals("domain")) continue;
                domain = (String)metadata.get(key);
            }
            for (JasmineSingleResult jsr : jiv.getValues()) {
                Notification not = new Notification();
                not.attribute("eventType", "monitoring");
                not.attribute("timestamp", jsr.getTimestamp());
                if (!simpleName) {
                    indicatorName = this.composeName(indicatorName, jsr.getName());
                }
                String[] fields = indicatorName.split("-");
                String component = "";
                if (fields.length < 5) {
                    this.logger.warn((Object)("Invalid indicator name : indicatorName: " + indicatorName), new Object[0]);
                    component = "?";
                    not.attribute("measureUnit", "?");
                    not.attribute("measureName", indicatorName);
                } else {
                    component = fields[2];
                    String realIndicatorName = fields[3];
                    realIndicatorName = realIndicatorName.substring(0, 1).toLowerCase() + realIndicatorName.substring(1);
                    not.attribute("measureUnit", fields[4]);
                    not.attribute("measureName", realIndicatorName);
                }
                if (jsr.getValue() instanceof Integer) {
                    not.attribute("measureValue", ((Integer)jsr.getValue()).longValue());
                } else if (jsr.getValue() instanceof Long) {
                    not.attribute("measureValue", (long)((Long)jsr.getValue()));
                } else if (jsr.getValue() instanceof Float) {
                    not.attribute("measureValue", ((Float)jsr.getValue()).longValue());
                } else {
                    not.attribute("measureValue", jsr.getValue());
                }
                not.attribute("fqn", "/" + domain + "/" + jiv.getTarget() + "/" + component);
                try {
                    if (this.endpoint != null) {
                        this.endpoint.publish(not);
                        this.logger.debug((Object)("Publish not=" + not), new Object[0]);
                        continue;
                    }
                    this.logger.debug((Object)("not=" + not), new Object[0]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

